#ifndef PHIBUTIL_H
#define PHIBUTIL_H

#include <pcimem.h>

#if defined(__cplusplus)
extern "C"
{
#endif

/*
 * global func(s)
 */
/* for single cluster */
unsigned int * phib_open(void);
unsigned int * phib_open_notestMC(int devid);
void phib_close(void);
void phib_piow(unsigned int addr, unsigned int cmd);
void phib_dmar(int size, unsigned int *buf);
void phib_dmaw(int size, unsigned int *buf);
int phib_dmaw_timeout(int size, unsigned int *buf);
int phib_calcsts(void);
void phib_wait(int nclk);
void phib_pioconfw(unsigned int addr, unsigned int cmd);

/* multi cluster extension */
void phib_alloc(int phib0, int nphibs);
void phib_set_nclusters(int n);
int phib_get_nclusters(void);
unsigned int * phib_openMC(int devid);
void phib_closeMC(int devid);
void phib_piowMC(int devid, unsigned int addr, unsigned int cmd);
void phib_dmarMC(int devid, int size, unsigned int *buf);
void phib_dmawMC(int devid, int size, unsigned int *buf);
int phib_dmaw_timeoutMC(int devid, int size, unsigned int *buf);
int phib_calcstsMC(int devid);
void phib_waitMC(int devid, int nclk);
void phib_pioconfwMC(int devid, unsigned int addr, unsigned int cmd);
void phib_optimizeDMA(double ww, double rw);
void phib_dmawtestMC(int devid, int size, unsigned int *buf);
void phib_dmartestMC(int devid, int size, unsigned int *buf);

void phib_danger_dmawMC(int devid, int size, unsigned int *buf, double ratio);
void phib_dmar_nowaitMC(int devid, int size, unsigned int *buf);
void phib_wait_dmar_assertionMC(int devid);
void phib_wait_dmar_deassertionMC(int devid);
void phib_start_dmawMC(int devid, int size, unsigned int *buf, double ratio);
void phib_finish_dmawMC(int devid, int len);
unsigned int * phib_mapped_addrMC(int devid);
void phib_add_rcntMC(int devid, int cnt);

#if defined(__cplusplus)
}
#endif

#endif /* PHIBUTIL_H */
