#!/bin/csh -f
#
# install.csh
#
# GRAPE-6 Library installation script for Linux/Alpha (for now)
#
# Supported hardwares
# UP-1000, UP-1100, UP-2000 (Irongate and Tsunami chipsets)
#
# Supported OSes (Well, versions of Linuxen)
#
# Kernel 2.2.14 and later (but not 2.3.x and later)
#
set homedir = $cwd
TOP:
cd $homedir
echo ========= Main Menu ========
echo 1. Compiling the device driver
echo 2. Installing the device driver '(need to be a superuser)'
echo 3. Testing the basic device driver functions and the PCI card.
echo 4. Compiling libraries and sample applications.
echo 5. Testing the libraries and sample applications
echo enter menu number '(1-5, or 0 to exit)':
set ans = $<
if ( $ans == 0 ) then
   exit 0
else if ( $ans == 1 ) then
   cd ../phibdd/pcimem
   echo Compiling the device driver.
   echo Which hardware do you have\?
   echo 1. UP-1000 and other AMD-750 based systems
   echo 2. UP-2000,DS-10,DS-20,XP-1000 and other TSUNAMI-based systems
   echo 3. Non-EV6 systems
   echo enter number '(1-3)':
   set ansh = $<
   if ( $ansh == 1 ) then
       /bin/cp -p Makefile.IG Makefile
   else if ( $ansh == 2 ) then
       /bin/cp -p Makefile.TSUNAMI Makefile
   else 
       echo Sorry, I do not know of these systems.
       exit 1
   endif
   rm pcimem.o    
   make  pcimem.o
   if ( $status == 0 ) then
      ls -al pcimem.o
      echo Seemingly make ended normally, return to the main menu
      goto TOP
   else
      echo make failed. You might have unsupported OS, compiler or whatever
      exit 1
   endif      
else if ( $ans == 2) then
   if (  `whoami` != "root" ) then
       echo You need to be a superuser to execute this part. Try again.
       exit 0
   else
       cat /proc/pci | grep PCI9080
       if ( $status != 0 ) then
          echo You have not yet installed the PCI interface card,
	  echo or your card is not properly working. Please check
	  echo your hardware configulation before proceeding
	  exit 1
       endif
       echo You seem to have at least one GRAPE-6 interface card.
       echo Where to install the device driver module\?\(/usr/local/lib\)
       set dir = $<
       if ( x$dir == x ) set dir = /usr/local/lib
       echo Place to install the module is $dir
       cp -pi ../phibdd/pcimem/pcimem.o $dir
       ls -al  $dir/pcimem.o
       echo if you see $dir/pcimem.o above, instalation is okay.
       /sbin/insmod -f   $dir/pcimem.o
       cat /proc/devices | grep pcimem
       if ( $status != 0 ) then
          echo insmod failed for unknown reason. Contact us.
	  exit 1
       endif
       set majorid = `cat /proc/devices | grep pcimem|awk '{print $1}'`
       mknod -m og+rw /dev/pcimem0 c $majorid 0
       ls -al /dev/pcimem0
       if ( $status != 0 ) then
          echo Failed to create the device special file... 
	  exit 1
       endif
       echo Creation of the device special file ended normally
       echo Adding the insmod command to a boot file
       if ( -e /sbin/init.d/boot.local ) then
          set bootfile = /sbin/init.d/boot.local
       else if (  -e /etc/rc.d/boot.local ) then
          set bootfile = /etc/rc.d/boot.local
       else
          echo Sorry, I could not figure out where is your boot.local file.
          echo You have to add the command
          echo /sbin/insmod -f   $dir/pcimem.o
          echo somewhere so that it is executed at booting,
          echo or you can do it manually after each boot.
          exit 1
       endif      
       grep pcimem $bootfile
       if ( $status == 0 ) then
          echo You seem to have added the insmod command already.
	  echo So no need to edit this file.
       else
          echo Preserving the original $bootfile ${bootfile}.bak
          cp -pi 	$bootfile  ${bootfile}.bak
          echo adding new stuff
          echo /sbin/insmod -f   $dir/pcimem.o >> $bootfile
          tail -f $bootfile
       endif
       echo copying FPGA design files to $dir/grape6
       mkdir $dir/grape6
       cp -rp ../grape6board $dir/grape6
       echo installing the configulation file
       echo How many modules do you have\? \(1,2,4 or 8\)
       set nmod = $<
       (echo NEWPATH $dir/grape6 ; cat g6config_export${nmod}.dat0) |\
          /bin/awk -f editconfpath.awk > $dir/grape6/g6config.dat0
       chmod og+r 	   $dir/grape6/g6config.dat0
       ls -al 	   $dir/grape6/g6config.dat0
       echo The configulation file is installed at $dir/grape6/
       echo Define eivironmental variable GRAPE6_CONFIG_FILE as  $dir/grape6/g6config.dat
       echo before using GRAPE-6. With csh and its variants, you would add
       echo setenv GRAPE6_CONFIG_FILE $dir/grape6/g6config.dat
       echo in your .cshrc file. 
       exit 0
   endif
else if ( $ans == 3 ) then
   echo Tesing basic function of PCI card
   cd ../phibdd/phib
   make phibtest
   ./phibtest 7
   echo =====================
   echo You should see something like the following:
cat <<EOF         
# of clusters: 1
bar2: 0x0b100000
offset: 0x00000000
devid, mptr(0) = 0 20000020000 0 2000
devid, rptr = 0 2000002f000
TBdmaMapLoad() not implemented yet.
## phib0:
## configration register:
0x00000000: 0x908010b5
0x00000004: 0x02800007
0x00000008: 0xffffff03
0x0000000c: 0x0000ff10
0x00000010: 0x0b10f000
0x00000014: 0x00009801
0x00000018: 0x0b100008
0x0000001c: 0x00000000
0x00000020: 0x00000000
0x00000024: 0x00000000
0x00000028: 0x00000000
0x0000002c: 0x908010b5
0x00000030: 0x00000000
0x00000034: 0x00000000
0x00000038: 0x00000000
0x0000003c: 0x00000000

## PCI9080 local register:
0x00000000: 0xfff00008
0x00000004: 0x00000001
0x00000008: 0x00000000
0x0000000c: 0x00000000
0x00000010: 0x00000000
0x00000014: 0x00000000
0x00000018: 0x490300c3
0x0000001c: 0x00000000
0x00000020: 0x00000000
0x00000024: 0x00000000
0x00000028: 0x00000000
0x0000002c: 0x00000000
EOF
   echo If you have seen, e.g., all f or something strange,
   echo it is likely that your PCI card is not correctly installed
   echo or you have chosen the wrong hardware when compiling the
   echo device driver. Check your hardware and try again.
   goto TOP
else if ( $ans == 4 ) then
   echo Compiling libraries and basic hardware test routines
   cd ../grape6
   make -f Makefile.linuxalpha
   cd ../g6hib
   make -f Makefile.linuxalpha
   echo Compiling a simple shared-timestep program
   cd ../simple-grape
   make -f Makefile.g6linux
   echo Compiling an individual timestep program
   cd ../pit
   make -f Makefile.la pit pit_grape6
   goto TOP
else if ( $ans == 5 ) then
   if ( x$GRAPE6_CONFIG_FILE  == x ) then
      echo env. var.  GRAPE6_CONFIG_FILE is not set.
      What path do you want\? \(/usr/local/grape6\)
      set confpath = $<
      if ( x$confpath == x ) then
         set confpath = /usr/local/grape6
      endif	 
      setenv GRAPE6_CONFIG_FILE $confpath/g6config.dat
    endif
    echo First perform a basic hardware test
    ./g6libtest
    echo ==============
    echo If the last few lines are
    cat <<EOF
--------------------------------------------------------
i:   98 acc: -1.340681e+00  -4.225591e-01  -1.402827e+00 
          jerk 9.279270e-01  -6.883621e-01  -3.075045e+00 
 pot, flag: -1.498402e+00 0
i:   99 acc: -2.233582e-01  7.912925e-01  -4.720528e-01 
          jerk 6.825142e-01  -1.057566e+00  1.227097e+00 
 pot, flag: -2.018687e+00 0
--------------------------------------------------------
EOF
   echo The hardware seems to have passed the  first test.
   echo We now proceed to the second test. \(press return\)
   set y = $<
   cd ../simple-grape
   ./grape6 < testparm
    echo ==============
    echo If the last few lines are
    cat <<EOF
--------------------------------------------------------
T=       5.000  E =    -0.253148379  
DE=-4.71895792e-04  V.R. =   0.497748
CM : 1.36325e-16 -4.92634e-18 -9.92045e-18
CMV: 4.43778e-17  4.87891e-19  8.53809e-18
AM : 5.19160e-03 -3.95216e-03  3.94282e-04
Exit  diag:CPU sec.=       17.90
--------------------------------------------------------
EOF
   echo The hardware seems to have passed the secnd test.
   echo We now proceed to the second test. \(press return\)
   cd ../pit
   ./pit_grape6  -i test128
    echo ==============
    echo If the last few lines are
    cat <<EOF
--------------------------------------------------------
Time= 10 N= 128
Energies(KE,PE,ETOT)=  0.285875491216492972  -0.541724041871020745  -0.255848550654527773;  de = 1.1852968733585655e-07
CMPOS= -1.00970527835021057e-07  1.39665046383977143e-07  -2.59323243356410216e-08
CMV = -3.30218132699178213e-09  1.92807652241947652e-08  -6.03574519661073672e-09
steps = 216652 Bsteps = 14734 CPU time 10.146484375
--------------------------------------------------------
EOF
   echo The hardware seems to have passed the Third test.
   echo This is the end of the pre-configured test.
endif
           
   

