#define DEBUG (1)

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/mman.h>
#include "../pcimem/pcimem.h"
#include "memmap.h"

/* local var(s) */

static char *devname[] =
{
    "/dev/"DEVNAME"0",
    "/dev/"DEVNAME"1",
    "/dev/"DEVNAME"2",
    "/dev/"DEVNAME"3",
    "/dev/"DEVNAME"4",
    "/dev/"DEVNAME"5",
    "/dev/"DEVNAME"6",
    "/dev/"DEVNAME"7",
};

static int mapped[][2] =
{
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
};

static int fd[] =
{
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static unsigned int * rptr[NPCIMEM];
static unsigned int * mptr[NPCIMEM];

/* local func(s) */
static void TBmemMap(int devid);

static unsigned int touch_page_dummy = 1;
void
touch_page(unsigned int *ptr, int size)
{
    int i;
    *ptr = touch_page_dummy;

    for (i = 0; i < size; i++)
    {
	ptr[i] = i;
    }
}

#if NODMA
unsigned long
TBdmaMapLoad(int devid, unsigned int * buf, int size)
{
    fprintf(stderr, "TBdmaMapLoad() not implemented yet.\n");
}
#else
unsigned long
TBdmaMapLoad(int devid, unsigned int *buf, int size)
{
    unsigned long pa;
    int psz = getpagesize();
    int off;

    touch_page(buf, size);

    pa = (unsigned long)buf/psz*psz;
    off = (unsigned long)buf - pa;
    /*
    fprintf(stderr, "virtual: buf: %08x pa: %08x off: %08x\n",
	    buf, pa, off);
    */
    if (-1 == ioctl(fd[devid], DMA_MAP_LOAD, &pa))
    {
	perror("TBdmaMapLoad() failed");
	exit (1);
    };
    (unsigned long)buf = pa + off;
    /*
    fprintf(stderr, "physical: buf: %08x pa: %08x\n", buf, pa);
    */
    return ((unsigned long)buf);
}
#endif

unsigned int
TBconfigRead(int devid, unsigned int addr)
{
    struct long_access ca;
    ca.addr = addr;
    ca.data = 0;

    if (fd[devid] < 0)
    {
	fprintf(stderr, "open %s first\n", devname[devid]);
	exit (1);
    }
    ioctl(fd[devid], READ_CFG, &ca);
    return (ca.data);
}

void
TBconfigWrite(int devid, unsigned int addr, unsigned int value)
{
    struct long_access ca;
    ca.addr = addr;
    ca.data = value;

    if (fd[devid] < 0)
    {
	fprintf(stderr, "open %s first\n", devname[devid]);
	exit (1);
    }
    ioctl(fd[devid], WRITE_CFG, &ca);
}

void
TBregWrite(int devid, unsigned int addr, unsigned int value)
{
    rptr[devid][addr>>2] = value;
    MB;
}

unsigned int
TBregRead(int devid, unsigned int addr)
{
    unsigned int ret;

    /*    ret =  *((u_int *)rptr[devid]+(addr>>2));*/
    ret =  (unsigned int) (rptr[devid][addr>>2]);
    return (ret);
/*




    unsigned int ret;

    ret =  rptr[devid][addr>>2];
    MB;
    return (ret);
*/
}

void
TBmemWrite(int devid, unsigned int addr, unsigned int value)
{
    mptr[devid][addr] = value;
    MB;
}

unsigned int
TBmemRead(int devid, unsigned int addr)
{
    unsigned int ret;

    ret =  mptr[devid][addr];
    MB;
    return (ret);
}


#if defined(__linux__)

static void
TBmemMap(int devid)
{
    unsigned int bar2;
    off_t offset;
    size_t psz = getpagesize();

    if (mapped[devid][1]) return;
    if (fd[devid] < 0)
    {
	fprintf(stderr, "open %dth device first\n",
		devid);
	exit (1);
    }
    bar2 = TBconfigRead(devid, 0x18);
    bar2 &= 0xfffffff0;
    printf("bar2: 0x%08x\n", bar2);
#if 0
    offset = bar2 / psz * psz;
#else
    offset = 0;
#endif    
    printf("offset: 0x%08x\n", offset);
    mptr[devid] = mmap(NULL,
		       ((MEM_SIZE*2)/psz+1)*psz,
		       PROT_READ | PROT_WRITE,
		       MAP_SHARED,
		       fd[devid],
		       offset);

    if ((long int)mptr[devid] == -1)
    {
	fprintf(stderr, "%s\n", devname[devid]);
	exit (1);
    }
    printf("devid, mptr(0) = %x %lx %x %x\n", devid, mptr[devid],bar2%psz,psz);
    mptr[devid] += bar2 % psz;
    rptr[devid] = mptr[devid]+(MEM_SIZE>>2);
    printf("devid, rptr = %x %lx\n", devid, rptr[devid]);
    TBconfigWrite(devid, 0x10, bar2+MEM_SIZE);

#if 0
    printf("mptr: 0x%lx\n", mptr[devid]);
    printf("rptr: 0x%lx\n", rptr[devid]);
#endif
    mapped[devid][1] = 1;
}

#elif defined (__DECC)

void
TBmemMap(int devid)
{
  unsigned long bar2;

  if (mapped[devid][1]) return;
  if (fd[devid] < 0)
    {
      fprintf(stderr, "open %dth device first\n",
	      devid);
      exit (1);
    }

  if (ioctl(fd[devid], MAP_BAR2_DENSE_ADDR) < 0)
    {
      fprintf(stderr, "ioctl failed for %dth device\n",
	      devid);
      exit (1);
    }

  mptr[devid] = mmap(NULL, 
		     MEM_SIZE+REG_SIZE,
		     PROT_WRITE,
		     MAP_FILE|MAP_SHARED,
		     fd[devid],
		     0);

  rptr[devid] = (unsigned int *)(((char *)(mptr[devid]))+MEM_SIZE);

  bar2 = TBconfigRead(devid, 0x18);
  TBconfigWrite(devid, 0x10, (bar2 & 0xfffffff0)+MEM_SIZE);

#if 0
  printf("mptr: 0x%lx\n", mptr[devid]);
  printf("rptr: 0x%lx\n", rptr[devid]);
#endif

  if ((int)mptr[devid] == -1)
    {
      fprintf(stderr, "mmap failed for %dth device\n",
	      devid);
      exit (1);
    }
  mapped[devid][1] = 1;

}

#else
 driver is not supported for this environment
#endif

/*
  TBopen(int devid)

  return values
  non 0: mapped address
  0: failure
  */
unsigned int *
TBopen(int devid)
{
    int ic;
    static int firstcall = 1;
    char buff[256];

    if (firstcall)
    {
	for (ic = 0; ic < NPCIMEM; ic++)
	{
	    rptr[ic] = NULL;
	    mptr[ic] = NULL;
	}
	firstcall = 0;
    }

    fd[devid] = open(devname[devid], O_RDWR);
    if (fd[devid] < 0)
    {
	sprintf(buff, "%s open failed", devname[devid]);
	perror(buff);
	return (0);
    }
    TBmemMap(devid);
    return (mptr[devid]);
}

void
TBterm(int devid)
{
    close(fd[devid]);
    fd[devid] = -1;
}

