#ifndef _G6CONTROL_
#define _G6CONTROL_

 /*
 * g6control.h
 */

/*
 * Some assumptions:
 *
 * use odd  byte parity
 */

/*
 * definition of local memory unit
 */
#define LMEM_MAXWORDS  131072


/*
 * definitions for JPW unit
 */

#define JPW_MAXWORDS 16
#define JPW_MAXPACKET (JPW_MAXWORDS+2)

typedef struct jpw_host_port{
    int we; /* write enable, low active! */
    ULONG data; /* 32 bit data with byte parity */
    
}JPW_HOST_PORT;

typedef struct jpw_memory_port{
    int addr;
    int we;
    int oe;
    ULONG data;
    ULONG parity;
    int addr_valid;
    int data_valid;
}JPW_MEMORY_PORT;

typedef struct jpw_internal_registers{
    int map[JPW_MAXWORDS];
    int ndata;
    int vcid;
    int adly;
    int wdly;
    int odly;
    int ddly;
    int physicalid;
    unsigned int data[JPW_MAXPACKET];
    unsigned int cmd[2];
    int perror;
    int wcount;
}JPW_INTERNAL_REGISTERS;

    
typedef struct jpw_internal_port{
    int ain;
    unsigned int din;
    int we;
}JPW_INTERNAL_PORT;

typedef struct jpw_struct{
    struct jpw_memory_port memory_port;
    struct jpw_internal_registers internal_register;
    struct jpw_host_port host_port;
    struct jpw_internal_port internal_port;
}JPW_STRUCT;

/*JPW control register address map*/
#define JPW_MAP_MAX (0xf)
#define JPW_NDATA_ADR (0x10)
#define JPW_VCID_ADR (0x11)
#define JPW_ADLY_ADR (0x12)
#define JPW_WDLY_ADR (0x13)
#define JPW_ODLY_ADR (0x14)
#define JPW_DDLY_ADR (0x15)

#define ADLY_DEFAULT  1
#define WDLY_DEFAULT  1
#define ODLY_DEFAULT  2
#define DDLY_DEFAULT  1

void init_g6control();
void reset_jp_status(struct jpw_struct  * jp_unit);
void set_jp_physicalid(struct jpw_struct  * jp_unit,
		       int physicalid);
void set_jp_control(struct jpw_struct  * jp_unit,
		    int address,
		    int data);

void write_jp_hostport(struct jpw_struct * jp_unit,
		       unsigned int data,
		       unsigned int parity,
		       int check_parity /*if zero, ignore parity  input*/);
void put_jpw_memory_port(struct jpw_memory_port * jpm);
void dump_jp_memory_port(struct jpw_struct * jp_unit);

void put_jpw_internal_port(struct jpw_internal_port * ji);

void set_jpw_internal_port(struct jpw_internal_port * ji,
			 int address,
			 int data,
			 int we);

void put_jpw_host_port(struct jpw_host_port * jh);
void set_jpw_host_port(struct jpw_host_port * jh,
		       unsigned int data,
		       unsigned int parity,
		       int we);


/*
 * IPW
 */
#define IPW_MAXMAP 16
#define IPW_MAXREG 13
#define IPW_MAXPACKET 8192

#define IPW_IPW_ADDRESS 1
#define IPW_JPW_ADDRESS 2
#define IPW_CTAB_ADDRESS 3
#define IPW_FO_ADDRESS 4
#define IPW_CALC_ADDRESS 5
#define IPW_TI_ADDRESS 6
#define IPW_ND_ADDRESS 16
#define IPW_TESTMODE_ADDRESS 17

#define IPW_INTERNAL_ADDRESS 0x400
#define IPW_JPW_INTERNAL_ADDRESS 0x800
#define IPW_CUTOFF_INTERNAL_ADDRESS 0xc00
#define IPW_RSCALE_INTERNAL_ADDRESS 0xc80
#define IPW_FO_INTERNAL_ADDRESS 0x1000
#define IPW_CALC_INTERNAL_ADDRESS 0x1400
#define IPW_TI_INTERNAL_ADDRESS 0x1800

#define IPW_LOCAL_ADDRESS_MASK 0x3ff
#define IPW_UNIT_ADDRESS_MASK 0xfc00

typedef struct ipw_host_port{
    int we; /* write enable, low active! */
    ULONG data; /* 32 bit data with byte parity */
    
}IPW_HOST_PORT;

typedef struct ipw_internal_registers{
    int map[IPW_MAXMAP];
    int ndata_ip;
    unsigned int data[IPW_MAXPACKET];
    unsigned int start_address;
    unsigned int ndata;
    int perror;
    int wcount;
}IPW_INTERNAL_REGISTERS;

    
typedef struct ipw_internal_port{
    int afp;
    int afp_valid;
    int a;
    int a_valid;
    ULONG dout;
    unsigned int testmode;
    int wefp[NPHYSPIPE];
    int wejp;
    int wect;
    int wefo;
    int wecalc;
    int wetl;
    int weth;
}IPW_INTERNAL_PORT;

typedef struct ipw_struct{
    struct ipw_internal_registers internal_register;
    struct ipw_host_port host_port;
    struct ipw_internal_port internal_port;
}IPW_STRUCT;


void put_ipw_internal_port(struct ipw_internal_port * ipi);

void put_ipw_host_port(struct ipw_host_port * ih);
    
void set_ipw_host_port(struct ipw_host_port * ih,
		       unsigned int data,
		       unsigned int parity,
		       int we);
void set_standard_ip_control(struct ipw_struct * ip_unit);


/*
 * definitions for FO unit
 */

#define FO_MAXWORDS 16

typedef struct fo_host_port{
    ULONG data; /* 32 bit data with byte parity */
    int vd;
    int nd;
    int sts;
    int wd;
    int active;
}FO_HOST_PORT;

typedef struct fo_pipeline_port{
    int a;
    int address_valid;
    unsigned int din[NPHYSPIPE];
    int is_valid[NPHYSPIPE];
}FO_PIPELINE_PORT;

typedef struct fo_nbl_port{
    int a;
    int address_valid;
    unsigned int din[NNBUNITS];
    int is_valid[NNBUNITS];
}FO_NBL_PORT;

typedef struct fo_internal_registers{
    int map[FO_MAXWORDS];
    int ni;
    int nw;
    int vcid;
    int inactive;
    unsigned int cmd[2];
    int wcount;
    int ests[4];
}FO_INTERNAL_REGISTERS;

    
typedef struct fo_internal_port{
    int ain;
    unsigned int din;
    int we;
}FO_INTERNAL_PORT;

typedef struct fo_struct{
    struct fo_pipeline_port pipeline_port;
    struct fo_nbl_port nbl_port;
    struct fo_internal_registers internal_register;
    struct fo_host_port host_port;
    struct fo_internal_port internal_port;
}FO_STRUCT;

/*FO control register address map*/
#define FO_MAP_MAX (0xf)
#define FO_CMD0_ADR (0x10)
#define FO_CMD1_ADR (0x11)
#define FO_NI_ADR (0x12)
#define FO_NW_ADR (0x13)
#define FO_INACTIVE_ADR (0x14)

#define FO_MAX_LATENCY 10
#define FO_PIPE_READ_LATENCY 0
#define FO_NBL_READ_LATENCY 0

#define FO_NDATA_ADDRESS (0x200)

void set_fo_pipe_port(struct fo_pipeline_port * fp,
		      int address,
		      int address_valid,
		      int iphysical,
		      unsigned int data,
		      int is_valid);
void put_fo_pipe_port(struct fo_pipeline_port * fp);

void set_fo_nbl_port(struct fo_nbl_port * fp,
		      int address,
		      int address_valid,
		      int inbl,
		      unsigned int data,
		      int is_valid);
void put_fo_nbl_port(struct fo_nbl_port * fp);

void dump_fo_nbl_port(struct fo_struct * fo_unit,
		       struct gchip * chip,
		      int mode /* 0: internal, 1: host */);


void put_fo_internal_port(struct fo_internal_port * fi);
void set_fo_internal_port(struct fo_internal_port * fi,
			 int address,
			 int data,
			 int we);

void put_fo_host_port(struct fo_host_port * fh);
void set_fo_host_port(struct fo_host_port * fh,
		      unsigned int data,
		      unsigned int parity,
		      int vd,
		      int nd,
		      int sts,
		      int active,
		      int wd);



/*
 * definitions calcr CALC unit
 */

#define CALC_MAXWORDS 16

typedef struct calc_memory_port{
    int addr;
    ULONG data;
    ULONG parity;
    int address_valid;
    int data_valid;
}CALC_MEMORY_PORT;


typedef struct calc_predictor_port{
    ULONG ix[5];
    ULONG tj;
    ULONG mass;
    ULONG index;
    int vd;
    int run;
}CALC_PIPELINE_PORT;

typedef struct calc_internal_registers{
    int lram;
    int lforce;
    int n;
    unsigned int cmd[2];
    int ests[2];
}CALC_INTERNAL_REGISTERS;
    
typedef struct calc_internal_port{
    int ain;
    unsigned int din;
    int we;
}CALC_INTERNAL_PORT;

typedef struct calc_struct{
    struct calc_memory_port memory_port;
    struct calc_predictor_port predictor_port;
    struct calc_internal_registers internal_register;
    struct calc_internal_port internal_port;
}CALC_STRUCT;

/*CALC control register address map*/
#define CALC_LRAM_ADR 0
#define CALC_LFORCE_ADR 1
#define CALC_N_ADR 2

#define CALC_MAX_LATENCY 10

#define CALC_LRAM_DEFAULT 2
#define CALC_LFORCE_DEFAULT 50

void set_calc_memory_port(struct calc_memory_port * cm,
			  int address,
			  int address_valid,
			  ULONG data,
			  int data_valid);
void put_calc_memory_port(struct calc_memory_port * cm);

void put_calc_internal_port(struct calc_internal_port * ci);

void set_calc_internal_port(struct calc_internal_port * fi,
			 int address,
			 int data,
			 int we);

void put_calc_predictor_port(struct calc_predictor_port * cp);

void set_calc_predictor_port(struct calc_predictor_port * cp,
			     struct jparticle * jp,
			     int coord_index,
			     int vd,
			     int run);




typedef struct chip_control_struct{
    struct jpw_struct jpu;
    struct ipw_struct ipu;
    struct fo_struct fou;
    struct calc_struct calcu;
    ULONG local_memory[LMEM_MAXWORDS];
}CHIP_CONTROL_STRUCT;

void put_jpport_data(int address,
		     struct jparticle * jp,
		     struct chip_control_struct * ccu);

void unpack_jparticle_from_memory_data(struct jparticle * jp,
				       ULONG memdata[8]);

void initialize_chip_control(struct chip_control_struct *ccu);

void put_ipport_particle(struct gchip * chip,
			 struct chip_control_struct * ccu,
			 int ni,
			 int nvp);

void interpret_ipw_hostport_data(int start_address,
				 int nwords,
				 int data[],
				 struct chip_control_struct *ccu);

void dump_cutoff_table_in_host_port(struct chip_control_struct *ccu);

void dump_fo_pipe_port(struct fo_struct * fo_unit,
		       struct gchip * chip);
void dump_fo_host_port(struct fo_struct * fo_unit,
		       struct gchip * chip);

void do_calc(struct chip_control_struct * ccu);
void write_calc_through_ipw(struct chip_control_struct * ccu,
			    int address,
			    unsigned int data);
void write_ti_through_ipw(struct chip_control_struct * ccu,
			    ULONG ti);
void write_rscale_through_ipw(struct chip_control_struct * ccu,
			    ULONG rscale);


void copy_jpw_vcid_to_fo_vcid(struct chip_control_struct * ccu);

void send_nbread_through_ipw(struct chip_control_struct * ccu,
			     int id, int mask);
int get_fo_vcid(struct chip_control_struct * ccu);

void send_fo_ni_through_ipw(struct chip_control_struct * ccu,int ni);

#endif

