/*
 * MULTEST.C
 *
 * test vector generator for 
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Dec 29 1997
 *
 * OUTPUT FORMAT: HEX format
 * in1 in2 product
 * hex format: packed (in the order of exponent, sign, zero and mantissa)
 *
 */
#include "grape6sim.h"
void print_mult_test(ULONG exp1,
		    ULONG sign1,
		    ULONG zero1,
		    ULONG mantissa1,
		    ULONG exp2,
		    ULONG sign2,
		    ULONG zero2,
		     ULONG mantissa2);
void print_mult_test(ULONG exp1,
		     ULONG sign1,
		     ULONG zero1,
		     ULONG mantissa1,
		     ULONG exp2,
		     ULONG sign2,
		     ULONG zero2,
		     ULONG mantissa2)
{
  ULONG in1, in2, pro, nbits;
  double f1, f2, fpro, err;
  nbits = BITS;
  in1 = compose_float(nbits, exp1, sign1,  zero1,  mantissa1);
  in2 = compose_float(nbits, exp2, sign2,  zero2,  mantissa2);
  pro =  mult(in1, in2,  nbits, nbits, nbits);
  
  f1 = convert_grape_float_to_double(in1, nbits);
  f2 = convert_grape_float_to_double(in2, nbits);
  fpro =  convert_grape_float_to_double(pro, nbits);
  err = fpro-f1*f2;
  if (fpro != 0.0) err = err/fpro;
  printf("%lx %lx %lx # %le %le %le %le\n", in1, in2, pro,
	 f1, f2, fpro, err);
}


main()
{
  ULONG exp1, sign1, zero1, mantissa1;
  ULONG exp2, sign2, zero2, mantissa2;
  int  i, j;
  
  for(i= 0;i < BITS-1; i ++)
    for(j= 0;j < BITS-1; j ++){
      exp1 = INTERACTION_POSITION_EXP_OFFSET;
      exp2 = exp1 ;
      sign1 = sign2 = 0;
      zero1 = zero2 = 0;
      mantissa1 = mantissa2 = (ULONG_ONE) << (BITS-1);
      mantissa1 += (ULONG_ONE) <<i;
      mantissa2 += (ULONG_ONE) <<j;
      print_mult_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
    }
  for(i= 0; i<1024; i+=13){
    exp1 = i;
    exp2 = i*11 % 1023;
    sign1 = sign2 = 0;
    zero1 = zero2 = 0;
    mantissa1 = mantissa2 = ((ULONG_ONE) << BITS)-1;
    print_mult_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
  }
  for(i= 0;i <10; i ++){
    exp1 = ULONG_ONE <<i;
    exp2 = exp1 + i;
    sign1 = sign2 = 0;
    zero1 = zero2 = 0;
    mantissa1 = mantissa2 = ((ULONG_ONE) << BITS)-1;
    print_mult_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
    sign1 = 1;
    print_mult_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
    zero1 = 1;
    print_mult_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
  }
  srandom(1234567);
  for (i=0; i< 100; i++){
    exp1 = exp2 = (random() %512) + 256 ;
    sign1 =random();
    sign2 =random();
    zero1 = zero2 = 0;
    mantissa1 = random();
    mantissa2 = random();
    mantissa1 |= (ULONG_ONE) << (BITS-1);
    mantissa2 |= (ULONG_ONE) << (BITS-1);
    print_mult_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
  }
  for (i=0; i< 100; i++){
    exp1 =  (random() %512) + 256 ;
    exp2 = (random() %512) + 256 ;
    sign1 =random();
    sign2 =random();
    zero1 = zero2 = 0;
    mantissa1 = random();
    mantissa2 = random();
    mantissa1 |= (ULONG_ONE) << (BITS-1);
    mantissa2 |= (ULONG_ONE) << (BITS-1);
    print_mult_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
  }
}
