/*
 * gview.c : Utility program to see GRAPE format snapshot.
 *
 * J. Makino   89/09/25   Ver. 1.00 (created)
 *
 */
#define SHORTREAL
#ifdef SHORTREAL
#   define REAL float
#else
#   define REAL double
#endif

#ifdef MSC
#    define SHORTINT
#else
#    define LONGINT
#endif
#define NMAX 5000
#define NDIM 3
#include <math.h>
#include <stdio.h>


static REAL x[NMAX][NDIM];
static REAL v[NMAX][NDIM];
static REAL a[NMAX][NDIM];
static REAL m[NMAX];
static long raster[16384];
static FILE * infile;
main()
{
    	static int  n;
    	static REAL dt, tstop, dtout, dtsnapout, eps2;
    	static REAL time, tnext, tsnapnext;
    	int x1,x2,y1,y2,cmode;
 	if(set_input_binary_file(&infile)){
    		puts("snap file open error");
    		exit(1);
    	}
    	set_out_raster_file();
        initialize_plot();
    	get_window_parms(&x1,&y1,&x2,&y2,&cmode);
    	printf("window_parms : %d %d %d %d %d\n", x1, y1, x2, y2, cmode);
    	while(read_snap_binary(&n,&time,m,x,v,NMAX)==0){
    		printf("Time=%f\n", time);
    		plot_particles(n,x);
    		write_raster(x1,y1,x2,y2,raster,cmode);
    	}
}
