//
// pit_hostonly.C
//
// Version 2001/3/11 Jun Makino
//
// serves host-only version of calculate_acc_and_jerk_for_list
//
// *should not* do anything more complecated in here.

#include "pit_system.h"
#include "mpi.h"
MPI_Status status;


inline void particle::accumulate_acc_and_jerk(particle* bj,
				    real eps2)

{
    vector d_pos = bj->pred_pos-pred_pos;
    vector d_vel = bj->pred_vel-pred_vel;
    //    PRC(index); PRL(bj->index);
    //    PRL(bj->pred_pos);PRL(pred_pos);PRL(d_pos); 
    real distance_squared = d_pos * d_pos;
    real r2inv = 1.0 / (distance_squared + eps2);
    real a3 = -3.0 * (d_pos * d_vel) * r2inv;
    real mrinv = bj->get_mass() * sqrt(r2inv);
    pot -= mrinv;
    real mr3inv = mrinv * r2inv;
    acc += mr3inv * d_pos;
    jerk += mr3inv * (d_vel + a3 * d_pos);
}

class pvajp{
public:
    vector pos;
    vector vel;
    vector acc;
    vector jerk;
    real pot;
};

void calculate_acc_and_jerk_for_list_on_host_using_mpi(particle* pb,
						       int nbody,
						       node_time* nt, 
						       int  n_next,
						       real eps2,
						       int nprocs,
						       int myid)
{
    cerr << "Enter calculate_acc_and_jerk_for_list_on_host" << endl;
    
    real sys_t = nt[0].next_time;
    int i,j;
    for (i = 0; i < n_next; i++) {
	particle *bi = nt[i].pptr;
	bi->predict_loworder(sys_t);
	bi->clear_interaction();
    }
    for (i = 0; i < n_next; i++) {
	particle *bi = nt[i].pptr;
	particle *bj = pb;
	for(j=0;j<nbody;j++,bj++){
	    if (bi->get_index() != bj->get_index())bi->accumulate_acc_and_jerk(bj,eps2);
	}
    }
    if (nprocs == 1) return;
    static pvajp * psource = NULL;
    static pvajp * pdest = NULL;
    particle pcopy;
    int nsend, nreceive;
    if (psource == NULL){
	psource = new pvajp[nbody+100];
	pdest = new pvajp[nbody+100];
    }
    //
    // collect contributions from forces on other processors
    //
    pvajp *pvptr = psource;
    for(i = 0; i <n_next;i++){
	particle *bi = nt[i].pptr;
	pvptr->pos = bi->get_pred_pos();
	pvptr->vel = bi->get_pred_vel();
	pvptr->acc = bi->get_acc();
	pvptr->jerk = bi->get_jerk();
	pvptr->pot = bi->get_pot();
    }
    nsend = n_next;

    for(int ip = 0; ip<nprocs; ip++){
	// first transfer nsend....
	cerr << "Myid = " << myid << " ip=" << ip<<endl; 
	MPI_Send( &nsend, 1, MPI_INT, (myid+1)%nprocs,ip*10 , MPI_COMM_WORLD);
	MPI_Recv( &nreceive, 1, MPI_INT, (myid+nprocs-1)%nprocs,ip*10 ,
		  MPI_COMM_WORLD,&status);
	PRC(myid); PRC(nsend); PRL(nreceive);
	if ((ip == nprocs - 1)&&(n_next != nreceive)){
	    // after one ring rotation, something went wrong...
	    PRC(ip); PRC(n_next); PRL(nreceive);
	    exit(-1);
	}
	// then transfer particle data and perform force calculation
	if (nsend > 0) MPI_Send( &psource, 13*nsend, MPI_DOUBLE,
				 (myid+1)%nprocs,ip*10+1 , MPI_COMM_WORLD);
	if (nreceive > 0) MPI_Recv( &pdest, 13*nreceive, MPI_DOUBLE,
				    (myid+nprocs-1)%nprocs,ip*10+1 ,
				    MPI_COMM_WORLD,&status);
	if ((nreceive > 0)&&(ip<nprocs-1)){
	    pvajp *pvptr = pdest;
	    for(i = 0; i <nreceive;i++){
		pcopy.set_pred_pos(pvptr->pos);
		pcopy.set_pred_vel(pvptr->vel);
		pcopy.set_acc(pvptr->acc);
		pcopy.set_jerk(pvptr->jerk);
		pcopy.set_pot(pvptr->pot);
		particle *bj = pb;
		for(j=0;j<nbody;j++,bj++){
		    pcopy.accumulate_acc_and_jerk(bj,eps2);
		}
		pvptr->acc= pcopy.get_acc();
		pvptr->jerk=pcopy.get_jerk();
		pvptr->pot=pcopy.get_pot();
	    }
	}
	if (ip==nprocs-1){
	    pvajp *pvptr = pdest;
	    for(i = 0; i <n_next;i++){
		particle *bi = nt[i].pptr;
		bi->set_acc(pvptr->acc);
		bi->set_jerk(pvptr->jerk);
		bi->set_pot(pvptr->pot);
	    }
	}
    }
}

	


void particle_system::calculate_acc_and_jerk_for_list(int n_next,
						      bool &restart_grape)
{
    //    cerr << "Enter calculate_acc_and_jerk_for_list" << endl;
    calculate_acc_and_jerk_for_list_on_host_using_mpi(pb, n, nt, n_next,
					     eps2,nprocessors,myprocid);
}

