/*
 *
 * G6HIBTEST.C
 */ 
/* #include <stdinc.h>*/
#include <stdlib.h>
#include <sys/resource.h>
#include <sys/time.h>
#include "phibutil.h"

#define DEFINE_IN_GRAPPE6UTIL 

#include "../grape6/g6chip_simlib.h"
#include "grape6util-local.h"
#include "grape6util.h"


double pow();
double sqrt();


double cpu_second()			
{
    struct rusage usage;
    if(getrusage(RUSAGE_SELF,&usage)){
	fprintf(stderr,"getrusage failed\n");
    }
    return  usage.ru_utime.tv_sec + usage.ru_utime.tv_usec*1e-6;
}
static double tstart;
static struct timeval timearg;
static struct timezone zonearg;
double wall_second()
{
    
    if(gettimeofday(&timearg,&zonearg)){
	fprintf(stderr,"Timer failed\n");
    }
    return  timearg.tv_sec + timearg.tv_usec*1e-6 - tstart;
}

void wall_init()
{
    tstart = wall_second();
}


#define MAX_PACKET_LENGTH 16384
unsigned int dbuf[MAX_PACKET_LENGTH];

double cpu0, wall0;
void timer_init(char * s)
{
    printf("Timer init for test %s\n", s);
    wall0 = wall_second();
    cpu0 = cpu_second();
}

void timer_out(char * s, double nbytes)
{
    double wall, cpu;
    wall = wall_second();
    cpu = cpu_second();
    printf("%s, Wall = %12.5e CPU= %12.5e  %12.3fMB/s %12.3fMB/s\n",s,
	   wall - wall0, cpu-cpu0, nbytes/(wall-wall0)/1e6,
	   nbytes/(cpu-cpu0)/1e6);
}

void time_linkread(int boardid,
		   int packet_length,
		   int repeat_count)
{
    int i;
    timer_init("linkread");
    if (packet_length > MAX_PACKET_LENGTH){
	fprintf(stderr, "Too large packet length %d\n", packet_length);
	exit(-1);
    }
    for(i=0;i<repeat_count; i++){
	linkread(boardid, packet_length, dbuf);
    }
    timer_out("linkread", ((double)repeat_count)*packet_length*4);
}

void time_linkwrite(int boardid,
		   int packet_length,
		   int repeat_count)
{
    int i;
    timer_init("linkwrite");
    if (packet_length > MAX_PACKET_LENGTH){
	fprintf(stderr, "Too large packet length %d\n", packet_length);
	exit(-1);
    }
    for(i=0;i<repeat_count; i++){
	linkwrite(boardid,2, packet_length, dbuf);
    }
    timer_out("linkwrite", ((double)repeat_count)*packet_length*4);
}

main(int argc, char **argv)
{
    int boardid = 0;
    if (argc > 1){
	boardid = atoi(argv[1]);
    }
    if (linkopen(boardid)){
	fprintf(stderr,"linkopen for boardid = %d failed\n", boardid);
	return -1;
    }
    time_linkread(boardid, 4096, 4096);
    time_linkwrite(boardid, 4096, 4096);
}
