fb_mmap(struct file *file, struct vm_area_struct * vma)
{
	int fbidx = GET_FB_IDX(file->f_dentry->d_inode->i_rdev);
	struct fb_info *info = registered_fb[fbidx];
	struct fb_ops *fb = info->fbops;
	struct fb_fix_screeninfo fix;
	struct fb_var_screeninfo var;
	unsigned long start;
	u32 len;

	if (!fb)
		return -ENODEV;
	if (fb->fb_mmap)
		return fb->fb_mmap(info, file, vma);
#if defined(__sparc__) && !defined(__sparc_v9__)
	/* Should never get here, all fb drivers should have their own
	   mmap routines */
	return -EINVAL;
#else
	fb->fb_get_fix(&fix, PROC_CONSOLE(info), info);

	/* frame buffer memory */
	start = (unsigned long)fix.smem_start;
	len = (start & ~PAGE_MASK)+fix.smem_len;
	len = (len+~PAGE_MASK) & PAGE_MASK;
	if (vma->vm_offset >= len) {
		/* memory mapped io */
		vma->vm_offset -= len;
		fb->fb_get_var(&var, PROC_CONSOLE(info), info);
		if (var.accel_flags)
			return -EINVAL;
		start = (unsigned long)fix.mmio_start;
		len = (start & ~PAGE_MASK)+fix.mmio_len;
		len = (len+~PAGE_MASK) & PAGE_MASK;
	}
	start &= PAGE_MASK;
	if ((vma->vm_end - vma->vm_start + vma->vm_offset) > len)
		return -EINVAL;
	vma->vm_offset += start;
	if (vma->vm_offset & ~PAGE_MASK)
		return -ENXIO;
#if defined(__sparc_v9__)
	vma->vm_flags |= (VM_SHM | VM_LOCKED);
	{
		unsigned long align, j;
		for (align = 0x400000; align > PAGE_SIZE; align >>= 3)
			if (len >= align && !((start & ~PAGE_MASK) & (align - 1)))
				break;
		if (align > PAGE_SIZE && vma->vm_start & (align - 1)) {
			/* align as much as possible */
			struct vm_area_struct *vmm;
			j = (-vma->vm_start) & (align - 1);
			vmm = find_vma(current->mm, vma->vm_start);
			if (!vmm || vmm->vm_start >= vma->vm_end + j) {
				vma->vm_start += j;
				vma->vm_end += j;
			}
		}
	}
	if (io_remap_page_range(vma->vm_start, vma->vm_offset,
				vma->vm_end - vma->vm_start, vma->vm_page_prot, 0))
		return -EAGAIN;
	vma->vm_flags |= VM_IO;
#else
#if defined(__mc68000__)
	if (CPU_IS_020_OR_030)
		pgprot_val(vma->vm_page_prot) |= _PAGE_NOCACHE030;
	if (CPU_IS_040_OR_060) {
		pgprot_val(vma->vm_page_prot) &= _CACHEMASK040;
		/* Use no-cache mode, serialized */
		pgprot_val(vma->vm_page_prot) |= _PAGE_NOCACHE_S;
	}
#elif defined(__powerpc__)
	pgprot_val(vma->vm_page_prot) |= _PAGE_NO_CACHE|_PAGE_GUARDED;
#elif defined(__alpha__)
	/* Caching is off in the I/O space quadrant by design.  */
#elif defined(__i386__)
	if (boot_cpu_data.x86 > 3)
		pgprot_val(vma->vm_page_prot) |= _PAGE_PCD;
#elif defined(__mips__)
	pgprot_val(vma->vm_page_prot) &= ~_CACHE_MASK;
	pgprot_val(vma->vm_page_prot) |= _CACHE_UNCACHED;
#elif defined(__arm__)
#if defined(CONFIG_CPU_32) && !defined(CONFIG_ARCH_ACORN)
	/* On Acorn architectures, we want to keep the framebuffer
	 * cached.
	 */
	pgprot_val(vma->vm_page_prot) &= ~(PTE_CACHEABLE | PTE_BUFFERABLE);
#endif
#else
#warning What do we have to do here??
#endif
	if (remap_page_range(vma->vm_start, vma->vm_offset,
			     vma->vm_end - vma->vm_start, vma->vm_page_prot))
		return -EAGAIN;
#endif /* !__sparc_v9__ */
	return 0;
#endif /* ! sparc32 */
}
