#define DEBUG (0)
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/file.h>
#ifndef GCC
#ifndef __linux__
#include <sys/limits.h>
#else
#include <limits.h>
#endif
#endif
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include "memmap.h"

/* local var(s) */
static char *devname[] =
{
    
    "/dev/pcimem0",
    "/dev/pcimem1",
    "/dev/pcimem2",
    "/dev/pcimem3",
    "/dev/pcimem4",
    "/dev/pcimem5",
    "/dev/pcimem6",
    "/dev/pcimem7",
};

static int mapped[][2] =
{
    0, 0,
    0, 0,
    0, 0,
    0, 0,
    0, 0,
    0, 0,
    0, 0,
    0, 0,
};

static int fd[] =
{
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static caddr_t rptr[MAXCLUSTERS];
static caddr_t mptr[MAXCLUSTERS];

/* local func(s) */
static void TBmemMap(int devid);

static unsigned int touch_page_dummy = 1;
void
touch_page(unsigned int *ptr, int size)
{
    int i;
    *ptr = touch_page_dummy;

    for (i = 0; i < size; i++)
    {
	ptr[i] = i;
    }
}

unsigned long
TBdmaMapLoad(int devid, caddr_t buf, int size)
{
    unsigned long data;

    touch_page((u_int *)buf, size);
    data = (unsigned long)buf;

    if (-1 == ioctl(fd[devid], DMA_MAP_LOAD, &data))
    {
	perror("TBdmaMapLoad() failed\n");
	exit (1);
    };

    return (data);
}

void
TBconfigWrite(int devid, unsigned long addr, unsigned int value)
{
    struct long_access ca;
    ca.addr = addr;
    ca.data = value;

    if (fd[devid] < 0)
    {
	fprintf(stderr, "open %s first\n", devname[devid]);
	exit (1);
    }
    ioctl(fd[devid], WRITE_CFG, &ca);
}

unsigned int
TBconfigRead(int devid, unsigned int addr)
{
    struct long_access ca;
    ca.addr = addr;
    ca.data = 0;

    if (fd[devid] < 0)
    {
	fprintf(stderr, "open %s first\n", devname[devid]);
	exit (1);
    }
    ioctl(fd[devid], READ_CFG, &ca);
    return (ca.data);
}

void
TBregWrite(int devid, unsigned long addr, unsigned int value)
{
    *((u_int *)rptr[devid]+(addr>>2)) = (value);
    MB;    
}

unsigned int
TBregRead(int devid, unsigned long addr)
{
    unsigned int ret;

    ret =  *((u_int *)rptr[devid]+(addr>>2));
    MB;
    return (ret);
}

void
TBmemWrite(int devid, unsigned long addr, unsigned int value)
{
    *((u_int *)mptr[devid]+(addr)) = (value);
    MB;    
}

unsigned int
TBmemRead(int devid, unsigned long addr)
{
#if 1
    unsigned int ret;

    ret =  (*(((u_int *)mptr[devid])+(addr)));
    MB;
    return (ret);
#else
    unsigned int ret;
    unsigned long tmp;

    tmp =  (*(u_long *)(((u_int *)mptr[devid])+(addr)));

    ret =  *((u_int *)&tmp);
    MB;
    return (ret);
#endif
}

void
TBmemMap(int devid)
{
    unsigned long bar2;

    if (mapped[devid][1]) return;
    if (fd[devid] < 0)
    {
	fprintf(stderr, "open %dth device first\n",
		devid);
	exit (1);
    }
    fprintf(stderr," TBmemMap calling ioctl... %d\n", devid);

    if (ioctl(fd[devid], MAP_BAR2_DENSE_ADDR) < 0)
    {
	fprintf(stderr, "ioctl failed for %dth device\n",
		devid);
	exit (1);
    }

    mptr[devid] = mmap(NULL,
		       MEM_SIZE+REG_SIZE,
		       PROT_WRITE,
		       MAP_FILE|MAP_SHARED,
		       fd[devid],
		       0);

    rptr[devid] = ((char *)(mptr[devid]))+MEM_SIZE;
    bar2 = TBconfigRead(devid, 0x18);
    TBconfigWrite(devid, 0x10, (bar2 & 0xfffffff0)+MEM_SIZE);

#if 0
    printf("mptr: 0x%lx\n", mptr[devid]);
    printf("rptr: 0x%lx\n", rptr[devid]);
#endif

#ifndef GCC    
    if ((int)mptr[devid] == -1)
#else
    if (mptr[devid] == (caddr_t)-1)
#endif	
    {
	fprintf(stderr, "mmap failed for %dth device\n",
		devid);
	exit (1);
    }
    mapped[devid][1] = 1;

}

/*
  TBopen(int devid)

  return values
  non 0: mapped address
  0: failure
  */
caddr_t
TBopen(int devid)
{
    int ic;
    static firstcall = 1;
    char buff[256];
    int ifd;

    if (firstcall)
    {
	for (ic = 0; ic < MAXCLUSTERS; ic++)
	{
	    rptr[ic] = NULL;
	    mptr[ic] = NULL;
	}
	firstcall = 0;
    }

    if ((fd[devid] = open(devname[devid], O_RDWR)) < 0)
    {
	sprintf(buff, "%s open failed", devname[devid]);
	perror(buff);
	return (0);
    }
    ifd = fd[devid];
    if(lockf(ifd,F_TLOCK,getpagesize())){
	if((errno == EACCES)||(errno == EAGAIN)){
	    fprintf(stderr,"Someone is using link, sleep..\n");
	    if(lockf(ifd,F_LOCK,getpagesize())){
		fprintf(stderr,"LOCKF failed with %d\n", errno);
	    perror("lockf");
		return NULL;
	    }else{
		fprintf(stderr,"Got link...\n");
	    }
	}else{
	    fprintf(stderr,"LOCKF failed with %d\n", errno);
	    perror("lockf");
	    return NULL;
	}
    }
    if(lockf(ifd,F_LOCK,getpagesize())){
	fprintf(stderr,"LOCKF failed with %d\n", errno);
	return NULL;
    }

    TBmemMap(devid);
    /*    fprintf(stderr,"TBopen return value = %lx\n", (long) mptr[devid]);*/
    return (mptr[devid]);
}

void
TBterm(int devid)
{
    close(fd[devid]);
    fd[devid] = -1;
}

