/*
 * GRAPE6.H
 *
 * header for functions exported from grape6 interface library
 * Copyright 2001 J. Makino 
 * Version 2001/3/29 J. Makino created 
 *
 */

#ifndef _GRAPE6_H
#define _GRAPE6_H

#if defined(_cplusplus_)
extern "C" {
#endif    

void g6_reset_(int * clusterid);
void g6_reset(int clusterid);
void g6_setcbjpmode_(unsigned int * clusterid,
		   int * board_address,
		   int * jp_mode,
		   int * output_select);

void g6_led_test(unsigned int boardid);
void g6_led_set(unsigned int boardid, unsigned int data);
void g6_reset_fofpga_(int *clusterid);
void g6_set_tunit_(int * newtunit);
void g6_set_xunit_(int * newxunit);
void g6_set_simulator_use_(int * clusterid, int * mode);
int g6_open_(int *clusterid);
int g6_close_(int *clusterid);
void g6_set_ti_(int *clusterid, double *ti);
int g6_set_j_particle_(int * clusterid,
		       int *address,
		       int *index,
		       double *tj, /* particle time */
		       double *dtj, /* particle time */
		       double *mass,
		       double a2by18[3], /* a2dot divided by 18 */
		       double a1by6[3], /* a1dot divided by 6 */
		       double aby2[3], /* a divided by 2 */
		       double v[3], /* velocity */
		       double x[3] /* position */);
void g6_set_nip_(int * clusterid, int * nip);
void g6_setup_njdata_(int * clusterid, int * njp);
void g6_set_njp_(int * clusterid, int * njp);
void g6_set_i_particle_scales_from_real_value_(int * clusterid,
					       int *address,
					       double acc[3],
					       double jerk[3],
					       double *phi,
					       double *jfactor,
					       double * ffactor);
void g6_set_ip_scales_(int * clusterid,
		       int *address,
		       double acc[3],
		       double jerk[3],
		       double *phi,
		       double *jfactor,
		       double *ffactor);
void g6_set_i_particle_(int * clusterid,
			int *address,
			int *index,
			double x[3], /* position */
			double v[3], /* velocity */
			double * eps2,
			double * h2);
void g6_setfoerrchkmode_(int * clusterid, int * mode);
int g6_get_force_etc_(int * clusterid,
		      double acc[][3],
		      double jerk[][3],
		      double phi[],
		      int nnbindex[],
		      int flag[]);
int g6_get_force_(int * clusterid,
		   double acc[][3],
	           double jerk[][3],
	           double phi[],
	           int flag[]);
int g6_test_flag_(int * clusterid, int * flagp);
void g6_adjust_ip_scales_(int * clusterid, int *address, int * flagp);
int g6_npipes_();
int g6_read_neighbour_list_(int * clusterid);
int g6_read_neighbour_list_old_(int * clusterid);
int  g6_get_neighbour_list_(int * clusterid, int * ipipe,
			   int * maxlength, int * nblen,
			   int nbl[]);
void g6calc_firsthalf0_(int * clusterid,
			int * nj,
			int * ni,
			int index[],
			double xi[][3],
			double vi[][3],
		      double fold[][3],
			double j6old[][3],
			double phiold[],
			double eps2[],
			double h2[],
			int * mode);
void g6calc_firsthalf_(int * clusterid,
		      int * nj,
		      int * ni,
		      int index[],
		      double xi[][3],
		      double vi[][3],
		      double fold[][3],
		      double j6old[][3],
		      double phiold[],
		      double *eps2,
		      double h2[]);
int g6calc_lasthalf_(int * clusterid,
		     int * nj,
		     int * ni,
		     int index[],
		     double xi[][3],
		     double vi[][3],
		     double *eps2,
		     double h2[],
		     double acc[][3],
		     double jerk[][3],
		     double pot[]);
int g6calc_lasthalf2_(int * clusterid,
		     int * nj,
		     int * ni,
		     int index[],
		     double xi[][3],
		     double vi[][3],
		     double *eps2,
		     double h2[],
		     double acc[][3],
		     double jerk[][3],
		     double pot[],
		      int nnbindex[]);
int g6calc_lasthalf0_(int * clusterid,
		     int * nj,
		     int * ni,
		     int index[],
		     double xi[][3],
		     double vi[][3],
		     double *eps2,
		     double h2[],
		     double acc[][3],
		     double jerk[][3],
		     double pot[],
		     int *mode);
int calculate_accel_by_grape6_separate_trial_noopen(int clusterid,
					     int ni,
					     double xi[][3],
					     double vi[][3],
					     int nj,
					     double xj[][3],
					     double vj[][3],
					     double m[],
					     double a[][3],
					     double jerk[][3],
					     double pot[],
					     double eps2);
int calculate_accel_by_grape6_noopen(int clusterid,
					     int n,
					     double x[][3],
					     double v[][3],
					     double m[],
					     double a[][3],
					     double jerk[][3],
					     double pot[],
					     double eps2);
void g6_set_ijp_mode_(int * clusterid, int * mode);
void g6_setmccount_(int * newval);
void g6_change_cbjpmode_(unsigned int *	 clusterid,unsigned int *mode);
void g6_dummywait();
void g6_fillzero_njdata(int clusterid, int nj);
int g6_initialize_jp_buffer(int clusterid, int size);
int g6_flush_jp_buffer(int  clusterid);
int g6_flush_jp_buffer_and_multisend(int  clusterid, int nclusters);


void g6_reset(int clusterid);
void g6_setcbjpmode(unsigned int  clusterid,
		   int  board_address,
		   int  jp_mode,
		   int  output_select);

void g6_reset_fofpga(int clusterid);
void g6_set_tunit(int newtunit);
void g6_set_xunit(int newxunit);
void g6_set_simulator_use(int  clusterid, int  mode);
int g6_open(int clusterid);
int g6_close(int clusterid);
void g6_set_ti(int clusterid, double ti);
int g6_set_j_particle(int  clusterid,
		       int address,
		       int index,
		       double tj, /* particle time */
		       double dtj, /* particle time */
		       double mass,
		       double a2by18[3], /* a2dot divided by 18 */
		       double a1by6[3], /* a1dot divided by 6 */
		       double aby2[3], /* a divided by 2 */
		       double v[3], /* velocity */
		       double x[3] /* position */);
int g6_set_j_particle_multisend(int  clusterid,
				int nclusters,
		       int address,
		       int index,
		       double tj, /* particle time */
		       double dtj, /* particle time */
		       double mass,
		       double a2by18[3], /* a2dot divided by 18 */
		       double a1by6[3], /* a1dot divided by 6 */
		       double aby2[3], /* a divided by 2 */
		       double v[3], /* velocity */
		       double x[3] /* position */);
void g6_setup_njdata(int clusterid, int njp);
void g6_set_njp_(int * clusterid, int * njp);
int g6_npipes();
int g6_read_neighbour_list(int clusterid);
int g6_read_neighbour_list_old(int clusterid);
int  g6_get_neighbour_list(int clusterid, int ipipe,
			   int maxlength, int * nblen,
			   int nbl[]);
void g6calc_firsthalf0(int  clusterid,
		       int  nj,
		       int  ni,
		       int index[],
		       double xi[][3],
		       double vi[][3],
		       double fold[][3],
		       double j6old[][3],
		       double phiold[],
		       double eps2[],
		       double h2[],
		       int  mode);
void g6calc_firsthalf(int clusterid,
		      int nj,
		      int ni,
		      int index[],
		      double xi[][3],
		      double vi[][3],
		      double fold[][3],
		      double j6old[][3],
		      double phiold[],
		      double eps2,
		      double h2[]);
int g6calc_lasthalf(int clusterid,
		    int nj,
		    int ni,
		    int index[],
		    double xi[][3],
		    double vi[][3],
		    double eps2,
		    double h2[],
		    double acc[][3],
		    double jerk[][3],
		    double pot[]);
int g6calc_lasthalf2(int clusterid,
		     int nj,
		     int ni,
		     int index[],
		     double xi[][3],
		     double vi[][3],
		     double eps2,
		     double h2[],
		     double acc[][3],
		     double jerk[][3],
		     double pot[],
		     int nnbindex[]);
int g6calc_lasthalf0(int clusterid,
		     int nj,
		     int ni,
		     int index[],
		     double xi[][3],
		     double vi[][3],
		     double *eps2,
		     double h2[],
		     double acc[][3],
		     double jerk[][3],
		     double pot[],
		     int mode);
int g6calc_lasthalf0a(int clusterid,
		     int nj,
		     int ni,
		     int index[],
		     double xi[][3],
		     double vi[][3],
		     double *eps2,
		     double h2[],
		     double acc[][3],
		     double jerk[][3],
		     double pot[],
		     int nnbindex[],
		     int mode);
void g6_set_ijp_mode(int clusterid, int mode);
void g6_setmccount(int newval);
void g6_change_cbjpmode(unsigned int clusterid,unsigned int mode);

int g6_print_chip_status_(int * clusterid);
int g6_print_chip_status(int clusterid);
void g6_reset_chip_vcids(int clusterid);

void g6_change_clock(int clusterid, int mode);
void g6_preset_i_particle_scales_from_real_value_(int * clusterid,
					       int *address,
					       double acc[3],
					       double jerk[3],
					       double *phi,
					       double *jfactor,
					       double * ffactor);
void g6_preset_i_particle_scales_from_real_value(int clusterid,
					       int address,
					       double acc[3],
					       double jerk[3],
					       double *phi);

void g6_set_sbufset(int val);
int g6_changed_index_();

int g6_changed_index();

void g6_reinitialize(int clusterid);
void g6_reinitialize_(int *clusterid);

int g6_set_j_particle_multisend_mxfast_(int * clusterid,
				 int * nclusters,
				 int *address,
				 int *index,
				 double *mass,
				 double x[3] /* position */);

int g6_read_jp_buffer_np(int clusterid);
int g6_set_jp_buffer_np(int clusterid, int val);
unsigned int * g6_get_jp_buffer_ptr(int clusterid);
int g6_get_jpspace(int clusterid);
int g6_get_nchips(int clusterid);
void g6_set_jpbuf_dump_mode(int mode);
int g6_flush_jp_buffer_and_multisend_async(int  clusterid, int nclusters,
					   int nnsend);
void  g6_initialize_chips(int clusterid);
void g6_setmcetc(int newval,int clusterid);

int g6_set_j_particle_mxonly(int  clusterid,
		       int address,
		       int index,
		       double mass,
		       double x[3] /* position */);

double g6_wall_second();    
double g6_cpu_second();    
#if defined(_cplusplus_)
} /* extern "C" */
#endif    
#endif /* _GRAPE6_H*/









