/*
 * SUBXTEST.C
 *
 * test vector generator for subx
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Dec 29 1997
 *
 * OUTPUT FORMAT: HEX format
 * in1 in2 out
 * hex format for out : packed (in the order of exponent, sign, zero and mantissa)
 * in1, in2: signed fixed point (64 bit)
 */
#include "grape6sim.h"
void print_subx_test(LONG in1,
		     LONG in2);
void print_subx_test(LONG in1,
		     LONG in2)
{
  ULONG dx;
  dx = subx(in1, in2);
  printf("%16lx %16lx %16lx # %le\n", in1, in2, dx, convert_grape_float_to_double(dx, INTERACTION_F_LEN_U));
}


main()
{
  LONG  in1,   in2;
  int i, j, k, l;
  for(l=0;l<LONGBITS;l+=3){
    in1 = (ULONG_ONE) << l;
    for(k=0;k<LONGBITS;k+=5){
      in2 = (ULONG_ONE) << k;
      print_subx_test(in1, in2);
    }
  }
  for(l=0;l<LONGBITS;l+=2){
    in1 = ((ULONG_ONE) << l) -1 ;
    for(k=0;k<LONGBITS;k+=7){
      in2 = ((ULONG_ONE) << k)-1;
      print_subx_test(in1, in2);
    }
  }

}
