/*
 * MULT.C
 *
 * general multiplier for normalized input with
 * sign, zero-bit
 *
 * function pmult
 *
 * assumes exponent bit length is same everywhere
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Nov 11 1997
 *
 * Things to be done
 *
 * --- implement conversion from/to IEEE double
 * --- systematic and random error check
 * Version 1.1 Dec 21 1977
 *       --- operation on Zero bit corrected
 *           used to be s1&s2, changed to s1|s2
 *
 */
#include "grape6sim.h"
ULONG mult( ULONG in1, /* multiplicant */
	    ULONG in2, /* multiplier */
	    ULONG in1bits, /* word length for input 1 */
	    ULONG in2bits, /* word length for input 2 */
	    ULONG outbits) /* word length for output */
{
  ULONG exp1, exp2, sign1,sign2, zero1, zero2, mantissa1, mantissa2,
    exponent, sign, zero, mantissa;
  ULONG exp_adjust = 0;
  decompose_float(in1, in1bits, &exp1, &sign1, &zero1, &mantissa1);
  decompose_float(in2, in2bits, &exp2, &sign2, &zero2, &mantissa2);
  dprintf(3, "in1 = %lx %lx %lx %lx\n", exp1, sign1, zero1, mantissa1);
  dprintf(3, "in2 = %lx %lx %lx %lx\n", exp2, sign2, zero2, mantissa2);
  dprintf(9,"(mult) in1, in2 = %lx %lx\n", mantissa1, mantissa2);
  mantissa = mantissa1 * mantissa2;
  dprintf(9,"(mult) mantissa%lx\n",mantissa);
  if ((mantissa & (ULONG_ONE <<(in1bits+in2bits -1))) == ULONG_ZERO){
    /* need to shift up; */
    mantissa <<= 1;
    exp_adjust = 1;
  }
  dprintf(9,"(mult) shifted mantissa%lx %lx\n",mantissa, (ULONG_ONE <<(in1bits+in2bits -1)));
  if (mantissa & (ULONG_ONE <<(in1bits+in2bits -1)) == ULONG_ZERO){
    /* original mantissa impossibley small */
    fprintf(stderr,"mult mantissa too small: 0x%lx 0x%lx\n", in1, in2);
  }

  mantissa = force_1_round_and_shift(mantissa, in1bits+in2bits, outbits);
  dprintf(9,"(mult) result = %lx \n", mantissa);

  exponent = exp1 + exp2 - INTERACTION_POSITION_EXP_OFFSET - exp_adjust;

  zero = zero1 | zero2;
  sign = sign1^sign2;
  return compose_float(outbits,  exponent, sign, zero, mantissa);
}

ULONG mult_by_3( ULONG in, /* multiplicant */
	    ULONG nbits) /* mantissa length  */
{
  ULONG exp1, sign1, zero1,  mantissa1,  exponent, sign, zero, mantissa;
  ULONG exp_adjust = 2;
  decompose_float(in, nbits, &exp1, &sign1, &zero1, &mantissa1);
  dprintf(9,"(mult) in = %lx \n", mantissa1);
  mantissa = mantissa1 * 3;
  dprintf(9,"(mult) mantissa%lx\n",mantissa);
  if ((mantissa & (ULONG_ONE <<(nbits+1))) == ULONG_ZERO){
    /* need to shift up; */
    mantissa <<= 1;
    exp_adjust --;
  }
  dprintf(9,"(mult) shifted mantissa%lx %lx\n",mantissa, (ULONG_ONE <<(nbits+1)));
  mantissa = force_1_round_and_shift(mantissa, nbits+2, nbits);
  dprintf(9,"(mult) result = %lx \n", mantissa);

  exponent = exp1 + exp_adjust;

  return compose_float(nbits,  exponent, sign1, zero1, mantissa);
}

    
#ifdef INTTEST
main()
{
  ULONG  in1, in2, inb1, inb2, outb, product;
  printf("enter in1, in2, inb1, inb2, outb: ");
  scanf("%lx%lx%ld%ld%ld",&in1, &in2, &inb1, &inb2, &outb);
  product =  mult(in1, in2,  inb1, inb2,  outb);
  printf("in1, in2,  inb1, inb2, outb, product  = 0x%lx 0x%lx %ld %ld %ld 0x%lx\n",
	 in1, in2, inb1, inb2, outb, product);
}
#endif

#ifdef TEST
main()
{
  ULONG  in1, in2, inb1, inb2, outb, product ;
  double in1f, in2f, realpro, gpro, err;
  set_debug_level(2);
  printf("enter in1f, in2f, inb1, inb2, outb: ");
  scanf("%le%le%ld%ld%ld",&in1f, &in2f, &inb1, &inb2, &outb);
  in1 = convert_double_to_grape_float(in1f, inb1);
  in2 = convert_double_to_grape_float(in2f, inb2);
  printf("in1 = %le %lx %le\n",	 in1f,
	 in1, convert_grape_float_to_double(in1, inb1));
  printf("in2 = %le %lx %le\n",	 in2f,
	 in2, convert_grape_float_to_double(in2, inb2));
  product =  mult(in1, in2,  inb1, inb2,  outb);
  realpro = in1f*in2f;
  gpro = convert_grape_float_to_double(product, outb);
  if(realpro != 0.0){
    err = (gpro - realpro)/realpro;
  }else{
    err = (gpro - realpro);
  }
  printf("outb, product  = %ld 0x%lx %le %le %le\n",
	  outb, product, realpro, gpro, err);
}
#endif
#ifdef TESTTHREE
main()
{
  ULONG  in1, in2, inb1, inb2, outb, product ;
  double in1f, in2f, realpro, gpro, err;
  set_debug_level(2);
  printf("enter inf, inb: ");
  scanf("%le%ld",&in1f,  &inb1);
  in1 = convert_double_to_grape_float(in1f, inb1);
  printf("in1 = %le %lx %le\n",	 in1f,
	 in1, convert_grape_float_to_double(in1, inb1));
  product =  mult_by_3(in1,  inb1);
  realpro = in1f*3;
  gpro = convert_grape_float_to_double(product, inb1);
  if(realpro != 0.0){
    err = (gpro - realpro)/realpro;
  }else{
    err = (gpro - realpro);
  }
  printf("outb, product  = %ld 0x%lx %le %le %le\n",
	  outb, product, realpro, gpro, err);
}
#endif
#ifdef ACCTEST
main()
{
  ULONG  in1, in2, inb1, inb2, outb, product, maxbits, ibits ;
  int ntest, i, itest, iscale;
  double in1f, in2f, realpro, gpro, err;
  double errsum, err2sum;
  printf("enter nbits, ntest: ");
  scanf("%ld%d", &maxbits, &ntest);
  inb1 = inb2 = outb;

  for(ibits = 6; ibits <= maxbits; ibits++){
    itest = 0;
    iscale = 2;
    errsum = err2sum = 0.0;
    srand48((long)12345);
      inb1 = inb2 = outb = ibits;
    for(i=0;i<ntest;i++){
      in1f = drand48();
      in2f = drand48();
      in1 = convert_double_to_grape_float(in1f, inb1);
      in2 = convert_double_to_grape_float(in2f, inb2);
      dprintf(5,"in1 = %22.16le %lx %le\n",	 in1f,
	      in1, convert_grape_float_to_double(in1, inb1));
      dprintf(5,"in2 = %22.16le %lx %le\n",	 in2f,
	      in2, convert_grape_float_to_double(in2, inb2));
      product =  mult(in1, in2,  inb1, inb2,  outb);
      realpro = in1f*in2f;
      gpro = convert_grape_float_to_double(product, outb);
      if(realpro != 0.0){
	err = (gpro - realpro)/realpro;
	itest ++;
	errsum += err;
	err2sum += err*err;
	if (fabs(err) > 0.1){
	  printf("in1 = %22.16le %lx %le\n",	 in1f,
		 in1, convert_grape_float_to_double(in1, inb1));
	  printf("in2 = %22.16le %lx %le\n",	 in2f,
		 in2, convert_grape_float_to_double(in2, inb2));
	  printf("outb, product  = %ld 0x%lx %le %le %le\n",
		 outb, product, realpro, gpro, err);
	}
	
	
      }
      if (itest == iscale){
	/*	printf("nbits, ntest, err, rms error = ");*/
	printf("%d %d %le %le %le %le %le\n",
	       outb, itest, errsum, err2sum, errsum/itest, sqrt(err2sum/itest),
	       fabs(errsum/itest));
	iscale *= 2;
      }
    }
  }
}

#endif

