/*
 * TCALCTEST.C
 *
 * test vector generator for tcalc
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Dec 29 1997
 *
 * OUTPUT FORMAT: HEX format
 * tnow, tilsb, dtimsbloc, dtout
 * all numbers are in the unsigned fixed point format
 *
 */
#include "grape6sim.h"
void print_tcalc_test(ULONG tnow,
		      ULONG tilsb,
		      ULONG dtimsbloc);
void print_tcalc_test(ULONG tnow,
		      ULONG tilsb,
		      ULONG dtimsbloc)
{
  ULONG dtout;
  tcalc(&dtout, tnow, tilsb, dtimsbloc);

  printf("%lx %lx %lx %lx\n", tnow, tilsb, dtimsbloc, dtout);
}


main()
{
  ULONG tnow;
  ULONG tilsb;
  ULONG dtimsbloc;
  int  i, j;
  for (i=0; i<LONGBITS; i++){
    for(j=0; j<2; j++){
      dtimsbloc = i;
      tilsb = j;
      tnow = 0x5555555555555555;
      print_tcalc_test(tnow,tilsb, dtimsbloc);
    }
  }
  for (i=0; i<LONGBITS; i++){
    for(j=0; j<6; j++){
      tnow = (ULONG_ONE) <<i;
      tilsb = 0;
      dtimsbloc = (j*11) % 64;
      print_tcalc_test(tnow,tilsb, dtimsbloc);
      print_tcalc_test(tnow-1,tilsb, dtimsbloc);
    }
  }
}

