/*
 * GAUSS.C
 *
 * testdata evaluation for gaussian cuttof
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Dec 1 1997
 *
 */
#include "grape6sim.h"

#define EC (M_2_SQRTPI)

double p0(double x)
{
  return erfc(x);
}
double p1(double x)
{
  return - EC* exp(-x*x);
}
double p2(double x)
{
  return 2*EC*x* exp(-x*x);
}
double p3(double x)
{
  return 2*EC*(1-2*x*x)* exp(-x*x);
}

double f0(double x)
{
  return EC *x * exp (-x*x) + erfc(x);
}
double f1(double x)
{
  return -2*EC *x *x* exp (-x*x);
}
double f2(double x)
{
  return -4*EC *(x -x*x*x)* exp (-x*x);
}
double f3(double x)
{
  return -4*EC *(1-5*x*x +2*x*x*x*x)* exp (-x*x);
}

double fabs_e(double x)
{
  return fabs(x) + 1e-50;
}

#ifdef MAIN
main()
{
  double  x;
  double dx = 1.0/1024;
  for(x=0;x<4;x+= dx){
#if 0
    printf("%e %e %e %e %e %e %e %e %e\n", x, p0(x),p1(x), p2(x), p3(x),
	   f0(x),f1(x), f2(x), f3(x));
#else    
    printf("%e %e %e %e %e %e %e %e %e\n", x,
	   p0(x),1.0/fabs_e(p1(x)), 1/sqrt(fabs_e(p2(x))), pow(fabs_e(p3(x)),-0.3333),
	   f0(x),1.0/fabs_e(f1(x)), 1/sqrt(fabs_e(f2(x))), pow(fabs_e(f3(x)),-0.3333));
#endif
  }
}
#endif
