/*
 * TEST_FORCE_HEX.C
 *
 * test vector generator for forcepipe
 *
 * Copyright Jun Makino 1998
 *
 * Version 1.0 March 2 1998
 *
 * Version 1.1 August 6 1998
 * Major change: generate clear whenever necessary

 
  */

/*

  functional test for modules in force calculation pipeline
  tests for cutoff units (i0 and i1)  are not made yet

 */
#include "grape6sim.h"

#define WITH_PINDEX 1

double tj, dtj, ti, x[5], xp[2];
ULONG xunit, tunit;


LONG xj[3], xi[3];
ULONG vj[3], mj, vi[3], eps2, h2, rscale;
LONG    fscale, jscale, phiscale;
ULONG clear;
LONG  acc[3],   jerk[3], phi;
ULONG  nbflag, r2p;
ULONG accflags[7],  testmode[NFORCETESTMODE];
ULONG rmin, accstatus[7];
unsigned int pindex;
void reset_testmode()
{
    int i;
    for(i=0;i<NFORCETESTMODE; i++)testmode[i] = 0;
}


void reset_inputdata()
{
    int k;
    for(k=0;k<3;k++){
	xj[k]=xi[k]=0;
	vi[k]=vj[k]=convert_double_to_grape_float((double)0,INTERACTION_F_LEN_U);
    }
    eps2=h2=convert_double_to_grape_float(0.0, INTERACTION_F_LEN_U);
    rscale=fscale=jscale=phiscale=clear=0;
    pindex = 0;
}

void reset_data()
{
    reset_testmode();
    reset_inputdata();
}
       
    
void print_params()
{
  
  int i;
  printf(" %16lx  %16lx  %16lx", xj[0], xj[1], xj[2]);
  printf(" %10lx  %10lx  %10lx %10lx", vj[0], vj[1], vj[2],mj);
  printf(" %16lx  %16lx  %16lx", xi[0], xi[1], xi[2]);
  printf(" %10lx  %10lx  %10lx", vi[0], vi[1], vi[2]);
#ifdef WITH_PINDEX
  if (clear == 1){
      pindex = 0;
  }else{
      pindex ++;
  }
  printf(" %8lx", pindex);
#endif  
  printf(" %10lx  %10lx", eps2,h2);
  printf(" %10lx %3lx %3lx %3lx %1lx",rscale,fscale,jscale,phiscale,clear);
  for(i=1; i<16; i++)printf(" %1lx", testmode[i]);
  printf("\n");
}
#if 0
void print()
{
  
  int i;
  printf("%d %16lx  %16lx  %16lx", FPIPE_SIM, xj[0], xj[1], xj[2]);
  printf(" %10lx  %10lx  %10lx %10lx", vj[0], vj[1], vj[2],mj);
  printf(" %16lx  %16lx  %16lx", xi[0], xi[1], xi[2]);
  printf(" %10lx  %10lx  %10lx", vi[0], vi[1], vi[2]);
  printf(" %10lx  %10lx", eps2,h2);
  printf(" %10lx %3lx %3lx %3lx %1lx",rscale,fscale,jscale,phiscale,clear);
  for(i=1; i<16; i++)printf(" %1lx", testmode[i]);
  printf("\n");
}
#endif

void print_command(int code)
{
    printf("%d ", code);
    print_params();
}

void print()
{
    print_command(FPIPE_SIM);
}

void unit_a_test()
{
    ULONG i, j, i1, i2;
    int k, l;

    reset_data();
    testmode[1] = 1;
    /*
      need to determine fscale for fadd. fcale is supplied directly
      to fadd, and used to set nshift value as: (version of 1998/3/3)
        nshifts = exponent + offset;
	loc = nshifts % ((LONG) LONGBITS);
	mantissa = force_1_round_and_shift(mantissa, inbits, (ULONG) loc);
	*/
    fscale = -512;


    for(l=0;l<64;l++){
	for(k=0;k<3;k++){
	    xi[k] = ULONG_ONE << ((l+k)%64);
	}
	/* Bit pattern : 00000100000 */
	clear=1;
	print();
    }
}
void unit_a_test2()
{
    ULONG i, j, i1, i2;
    int k, l;

    reset_data();
    testmode[1] = 1;
    fscale = -512;
    for(l=0;l<64;l++){
	for(k=0;k<3;k++){
	    xj[k] = ULONG_ONE << ((l+k)%64);
	}
	if(l==0){
	    clear=1;
	}else{
	    clear = 0;
	}
	print();
    }
}
void unit_a_test3()
{
    ULONG i, j, i1, i2;
    int k, l;

    reset_data();
    testmode[1] = 1;
    /*
      need to determine fscale for fadd. fcale is supplied directly
      to fadd, and used to set nshift value as: (version of 1998/3/3)
        nshifts = exponent + offset;
	loc = nshifts % ((LONG) LONGBITS);
	mantissa = force_1_round_and_shift(mantissa, inbits, (ULONG) loc);
	*/
    fscale = -512;


    for(l=0;l<64;l++){
	for(k=0;k<3;k++){
	    xi[k] = (ULONG_ONE << ((l+k)%64))-1;
	}
	/* Bit pattern : 00000100000 */
	for(k=0;k<64;k++){
	    j = (ULONG_ONE << k)-1;
	    
	    if(k==0){
		clear=1;
	    }else{
		clear = 0;
	    }
	    print();
	}
    }
}
void unit_a_test4()
{
    ULONG i, j, i1, i2;
    int k, l;

    reset_data();
    testmode[1] = 1;
    fscale = -512;
    for(l=0;l<64;l++){
	for(k=0;k<3;k++){
	    xi[k] = ULONG_ONE << ((l+k)%64);
	}
	clear=1;
	print();
    }
}
void unit_a_test5()
{
    ULONG i, j, i1, i2;
    int k, l;

    reset_data();
    testmode[1] = 1;
    fscale = -512;
    for(l=0;l<64;l++){
	for(k=0;k<3;k++){
	    xi[k] = (ULONG_ONE << ((l+k)%64))-1;
	}
	clear=1;
	print();
    }
}
void unit_b_test()
     /* dx2 = dx*dx */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[2] = testmode[4] = 1;
    for(l=0;l<25;l++){
	for(k=0;k<3;k++){
	    reset_inputdata();
	    fscale = -512;
	    clear = local_clear;
	    xj[k] = (ULONG_ONE << l) | (ULONG_ONE <<25);
	    print();
	    local_clear=0;
	}
    }
    for(l=0;l<25;l++){
	for(k=0;k<3;k++){
	    reset_inputdata();
	    fscale = -512;
	    clear = local_clear;
	    xj[k] = ((ULONG_ONE << l)-1) | (ULONG_ONE <<25);
	    print();
	    local_clear=0;
	}
    }
    for(l=0;l<64;l++){
	for(k=0;k<3;k++){
	    reset_inputdata();
	    fscale = -512;
	    local_clear=1;
	    clear = local_clear;
	    xj[k] = (ULONG_ONE << l)-1;
	    fscale = -512 +48-l*2;
	    print();
	}
    }
}

void unit_c_test()
     /* dr2xy = dx1 + dx2 */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[2] = testmode[4] = testmode[5] = 1;
    for(l=0;l<25;l++){
	reset_inputdata();
	fscale = -512+16;
	clear = local_clear;
	xj[0] = (ULONG_ONE <<25);
	xj[1] = (ULONG_ONE << l);
	print();
	xj[0] = (ULONG_ONE <<25)-1;
	xj[1] = (ULONG_ONE << l);
	print();
	local_clear=0;
	xj[1] = (ULONG_ONE <<25);
	xj[0] = (ULONG_ONE << l);
	print();
    }
}
void unit_c1_test()
     /* dr2ze  */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[2] = testmode[4] = testmode[5] = 1;
    for(l=0;l<25;l++){
	reset_inputdata();
	fscale = -512+16;
	clear = local_clear;
	xj[2] = (ULONG_ONE <<25);
	eps2  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	print();
	xj[2] = (ULONG_ONE <<25)-1;
	eps2  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	print();
	local_clear=1;
	eps2  = convert_double_to_grape_float((double)(ULONG_ONE << 25), INTERACTION_F_LEN_U);
	xj[2] = (ULONG_ONE << l);
	print();
    }
}

void unit_c2_test()
     /* r2 =  */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[2] = testmode[4] = testmode[5] = 1;
    for(l=0;l<25;l++){
	reset_inputdata();
	fscale = -512+16;
	clear = local_clear;
	xj[0] = (ULONG_ONE <<25);
	xj[2] = (ULONG_ONE << l);
	print();
	xj[0] = (ULONG_ONE <<25)-1;
	xj[2] = (ULONG_ONE << l);
	print();
	local_clear=0;
	xj[2] = (ULONG_ONE <<25);
	xj[0] = (ULONG_ONE << l);
	print();
    }
}

void unit_c_test2()
     /* dr2xy = dx1 + dx2, test exponent calculation etc */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[2] = testmode[4] = 1;
    for(l=0;l<64;l++){
	reset_inputdata();
	fscale = -512+16-l*2;
	clear = local_clear;
	xj[0] = ULONG_ONE ;
	xj[1] = (ULONG_ONE << l);
	print();
	local_clear=1;
	xj[1] = ULONG_ONE ;
	xj[0] = (ULONG_ONE << l);

	print();
    }
}

void unit_c1_test2()
     /* dr2ze test exponent calculation etc */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[2] = testmode[4] = 1;
    for(l=0;l<64;l++){
	double x = (ULONG_ONE << l);
	x = x*x;
	reset_inputdata();
	fscale = -512+16-l*2;
	clear = local_clear;
	xj[2] = ULONG_ONE ;
	eps2= convert_double_to_grape_float(x, INTERACTION_F_LEN_U);
	print();
	local_clear=1;
	eps2 =convert_double_to_grape_float(1.0, INTERACTION_F_LEN_U);
	xj[2] = (ULONG_ONE << l)-1;

	print();
    }
}

void unit_c2_test2()
     /* r2 =  test exponent calculation etc */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[2] = testmode[4] = 1;
    for(l=0;l<64;l++){
	reset_inputdata();
	fscale = -512+16-l*2;
	clear = local_clear;
	xj[0] = ULONG_ONE ;
	xj[2] = (ULONG_ONE << l);
	print();
	local_clear=1;
	xj[2] = ULONG_ONE ;
	xj[0] = (ULONG_ONE << l);

	print();
    }
}


void unit_d_test()
     /* r^-5  =   */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[3] = testmode[4] = testmode[5] = 1;
    for(l=0;l<=1024;l++){
	reset_inputdata();
	fscale = -512+48;
	clear = local_clear;
	eps2 = convert_double_to_grape_float(1.0 + 1.0/1024.0*l + 1.0/(1<<24)*13.0*l, INTERACTION_F_LEN_U);
	mj =  convert_double_to_grape_float(1.0, INTERACTION_F_LEN_U);
	print();
    }
}


void unit_e_test()
     /* mr5inv  =   */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[3] = testmode[4] = testmode[5] = 1;
    reset_inputdata();
    for(l=0;l<=24;l++){
	clear = 1;
	for(k=0;k<=24;k++){
	    fscale = -512+48;
	    eps2 = convert_double_to_grape_float(1.0 +  1.0/(1<<l), INTERACTION_F_LEN_U);
	    mj = convert_double_to_grape_float(1.0 +  1.0/(1<<k), INTERACTION_F_LEN_U);
	    print();
	    eps2 = convert_double_to_grape_float(1.0 -  1.0/(1<<l), INTERACTION_F_LEN_U);
	    mj = convert_double_to_grape_float(1.0 -  1.0/(1<<k), INTERACTION_F_LEN_U);
	    print();
	    clear = 1;
	}
    }
}

void unit_f_test()
     /* mr5inv  =   */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[4] =  testmode[8] = 1;
    reset_inputdata();
    for(l=0;l<=24;l++){
	clear = 1;
	for(k=0;k<=24;k++){
	    fscale = -512+48;
	    eps2 = convert_double_to_grape_float(1.0 +  1.0/(1<<l), INTERACTION_F_LEN_U);
	    mj = convert_double_to_grape_float(1.0 +  1.0/(1<<k), INTERACTION_F_LEN_U);
	    print();
	    eps2 = convert_double_to_grape_float(1.0 -  1.0/(1<<l), INTERACTION_F_LEN_U);
	    mj = convert_double_to_grape_float(1.0 -  1.0/(1<<k), INTERACTION_F_LEN_U);
	    print();
	    clear = 1;
	}
    }
}


void unit_g_test()
     /* mrinv  =   */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[3] =  testmode[8] = 1;
    reset_inputdata();
    for(l=0;l<=24;l++){
	clear = 1;
	for(k=0;k<=24;k++){
	    phiscale= fscale = -512+48;
	    eps2 = convert_double_to_grape_float(1.0 +  1.0/(1<<l), INTERACTION_F_LEN_U);
	    mj = convert_double_to_grape_float(1.0 +  1.0/(1<<k), INTERACTION_F_LEN_U);
	    print();
	    eps2 = convert_double_to_grape_float(1.0 -  1.0/(1<<l), INTERACTION_F_LEN_U);
	    mj = convert_double_to_grape_float(1.0 -  1.0/(1<<k), INTERACTION_F_LEN_U);
	    print();
	    clear = 1;
	}
    }
}


void unit_h_test()
     /* sqrt(r)   */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;
    print_command(FPIPE_CTAB_LINEAR);

    reset_data();
    testmode[6] = 1;
    for(l=0;l<=256;l++){
	reset_inputdata();
	phiscale = fscale = -512+48;
	clear = local_clear;
	rscale = convert_double_to_grape_float(0.5, CUTOFF_MANTISSA_LEN);
	eps2 = convert_double_to_grape_float(1.0 + 1.0/256.0*l + 1.0/(1<<16)*l, INTERACTION_F_LEN_U);
	print();
    }
    print_command(FPIPE_CTAB_RESET);
}


void unit_k_test()
     /* phi accumurate   */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[3] = testmode[8] =  testmode[11] = 1;
    for(l=0;l<=128;l++){
	reset_inputdata();
	phiscale = fscale = -512+l-32;
	clear = local_clear;
	mj = convert_double_to_grape_float(1.0, INTERACTION_F_LEN_U);
	print();
	local_clear = 1;
	mj = convert_double_to_grape_float(1.0-1.0/(1<<23), INTERACTION_F_LEN_U);
	print();
	
    }
    local_clear = 1;
    for(l=0;l<128;l++){
	reset_inputdata();
	phiscale = fscale = -512+32-l;
	clear = local_clear;
	mj = convert_double_to_grape_float(-ldexp(1.0, l), INTERACTION_F_LEN_U);
	print();
	local_clear = 1;
	mj = convert_double_to_grape_float(-(1.0-1.0/(1<<23))*ldexp(1.0,l), INTERACTION_F_LEN_U);
	print();
    }
}




void unit_l_test()
     /* ffact  =   */
{
    int k, l, l1, l2;
    int local_clear = 1;

    reset_data();
    testmode[3] =  testmode[8] = 1;
    reset_inputdata();
    for(l=0;l<=24;l++){
	clear = 1;
	
	for(k=0;k<3;k++){
	    reset_inputdata();
	    fscale = -512;
	    xj[k] = ((ULONG_ONE << ((l+k)%24))-1) | (ULONG_ONE <<25);
	}
	for(k=0;k<=24;k++){
	    mj = convert_double_to_grape_float(1.0 +  1.0/(1<<k), INTERACTION_F_LEN_U);
	    clear = local_clear;
	    print();
	    local_clear=0;
	}
    }
}

void unit_m_test()
     /* acc accumurate -- use dx   */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;

    reset_data();
    testmode[1] =  1;
    local_clear = 1;
    for(l=0;l<=64;l++){
	int k;
	reset_inputdata();
	phiscale = fscale = -512;
	clear = local_clear;
	for(k=0;k<3;k++){
	    xj[k] = ULONG_ONE<<((l+k)%64);
	}
	print();
	local_clear = 0;
    }
    local_clear = 1;
    for(l=0;l<=64;l++){
	int k;
	reset_inputdata();
	phiscale = fscale = -512;
	clear = local_clear;
	for(k=0;k<3;k++){
	    xj[k] = -((long)(ULONG_ONE<<((l+k)%64)));
	}
	print();
	local_clear = 0;
    }


}

void unit_n_test()
     /* xdot_j - xdot_i */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;
    
    reset_data();
    testmode[2] = testmode[3] = 1;
#if 0    
    for(l=0;l<25;l++){
	
	reset_inputdata();
	jscale = -512;
	clear = local_clear;
	for(k=0;k<3;k++){
	    vi[k] =  convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	    vj[k]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	}
	print();
    }
    for(l=0;l<25;l++){
	reset_inputdata();
	jscale = -512;
	clear = local_clear;
	for(k=0;k<3;k++){
	    vi[k] =  convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	    vj[k]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	}
	print();
    }
    
    for(l=0;l<25;l++){
	reset_inputdata();
	jscale = -512;
	clear = local_clear;
	for(k=0;k<3;k++){
	    vi[k] =  convert_double_to_grape_float(-(double)(ULONG_ONE), INTERACTION_F_LEN_U);
	    vj[k]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	}
	print();
    }
    
#endif    
    for(l=0;l<25;l++){
	reset_inputdata();
	jscale = -512;
	clear = local_clear;
	for(k=0;k<3;k++){
	    vi[k] =  convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	    vj[k]  = convert_double_to_grape_float(-(double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	}
	print();
    }
    
}
void unit_o_test()
     /* xv inner product, mult */
{
    ULONG i, j, i1, i2;
    int k, l, m;
    int local_clear = 1;
    
    reset_data();
    testmode[12] = testmode[13] = testmode[14] = 1;

    for(l=0;l<21;l++){
	for(k=0;k<21;k++){
	    for(m=0;m<3;m++){
		reset_inputdata();
		jscale = -512;
		clear = local_clear;
		vj[m]  = convert_double_to_grape_float(1.0 + 1.0/(ULONG_ONE << l),
						       INTERACTION_F_LEN_U);
		xj[m]  = (ULONG_ONE <<23) + (ULONG_ONE<<k);
		xj[(m+1)%3] = 1;
		print();
	    }
	    
	}
    }
#if 0
    /* This part is difficult to go through from host
       port, because the exponent of vj is not arbitorary
       */
    clear = 1;
    reset_inputdata();
    for(l=-512;l<512;l+=23){
	
	jscale = -512 - l + 24;
	for(k=0;k<3;k++){
	    vj[k]  = convert_double_to_grape_float(ldexp(1.0, l),
						   INTERACTION_F_LEN_U);
	    xj[k]  = 1;
	}
	print();
	clear = 1;
	
    }
#endif    
    reset_inputdata();
    clear = 1;
    for(l=-128;l<128;l+=11){
	
	jscale = -512 - l + 24;
	for(k=0;k<3;k++){
	    vi[k]  = convert_double_to_grape_float(ldexp(1.0, l),
						   INTERACTION_F_LEN_U);
	    xi[k]  = 1;
	}
	print();
	clear = 1;
	
    }
}

void unit_p_test()
     /* drdvxy = ... */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;
    
    reset_data();
    testmode[12] = testmode[13] = testmode[14] = 1;
    for(l=0;l<25;l++){
	reset_inputdata();
	xj[0] = 1; xj[1] =  ULONG_ONE <<8; xj[2] = ULONG_ONE <<16;
	jscale = -512;
	clear = local_clear;
	vj[0] =  convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	vj[1]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[2]  = convert_double_to_grape_float((double)(0), INTERACTION_F_LEN_U);
	print();
	vj[0]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
	vj[0]  = convert_double_to_grape_float(-(double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
	vj[0]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(-(double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
	vj[0]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(-(double)(ULONG_ONE<<l)-1, INTERACTION_F_LEN_U);
    }
#if 0
    /* this would be hard from host port */
    for(l=-510;l<510;l+=31){
	reset_inputdata();
	xj[0] = xj[1] =  1;
	jscale = -512-l;
	clear = local_clear;
	vj[0] =  convert_double_to_grape_float(ldexp(1.0+l/510.0,l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(ldexp(1.1-l/1020.0,l), INTERACTION_F_LEN_U);
	vj[2]  = convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
	vj[0] =  convert_double_to_grape_float(-ldexp(1.1,l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(ldexp(1.0,l), INTERACTION_F_LEN_U);
	vj[2]  = convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
    }
#endif
    reset_inputdata();
    clear = local_clear;

    for(l=-32;l<95;l+=5){
	xj[0] = xj[1] =  1;
	jscale = -512-l;
	vj[0] =  convert_double_to_grape_float(ldexp(1.0+l/510.0,l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(ldexp(1.1-l/1020.0,l), INTERACTION_F_LEN_U);
	vj[2]  = convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
	vj[0] =  convert_double_to_grape_float(-ldexp(1.1,l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(ldexp(1.0,l), INTERACTION_F_LEN_U);
	vj[2]  = convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
		print();
    }

}
void unit_q_test()
     /* drdvxy = ... */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;
    
    reset_data();
    testmode[12] = testmode[13] = testmode[14] = 1;
    for(l=0;l<25;l++){
	reset_inputdata();
	xj[0] = 1; xj[1] =  ULONG_ONE <<8; xj[2] = ULONG_ONE <<16;
	jscale = -512;
	clear = local_clear;
	vj[2] =  convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	vj[1]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[0]  = convert_double_to_grape_float((double)(0), INTERACTION_F_LEN_U);
	print();
	vj[2]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
	vj[2]  = convert_double_to_grape_float(-(double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
	vj[2]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(-(double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
	vj[2]  = convert_double_to_grape_float((double)(ULONG_ONE << l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(-(double)(ULONG_ONE<<l)-1, INTERACTION_F_LEN_U);
    }
    
    /*    for(l=-510;l<510;l+=31){ *this would cause trouble with host port */
    for(l=-32;l<96;l+=7){
	reset_inputdata();
	xj[0] = xj[1] =  1;
	jscale = -512-l;
	clear = local_clear;
	vj[2] =  convert_double_to_grape_float(ldexp(1.0+l/510.0,l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(ldexp(1.1-l/1020.0,l), INTERACTION_F_LEN_U);
	vj[0]  = convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
	vj[2] =  convert_double_to_grape_float(-ldexp(1.1,l), INTERACTION_F_LEN_U);
	vj[1] =  convert_double_to_grape_float(ldexp(1.0,l), INTERACTION_F_LEN_U);
	vj[0]  = convert_double_to_grape_float((double)(ULONG_ONE), INTERACTION_F_LEN_U);
	print();
    }
    
}

void unit_r_test()
     /* drdv*3 */
{
    ULONG i, j, i1, i2;
    int k, l, m;
    int local_clear = 1;
    
    reset_data();
    testmode[12] = testmode[13] =  1;
    for(l=0;l<21;l++){
	reset_inputdata();
	jscale = -512;
	clear = local_clear;
	vj[0]  = convert_double_to_grape_float(1.0 + 1.0/(ULONG_ONE << l),
					       INTERACTION_F_LEN_U);
	xj[0]  = 1; xj[1] = ULONG_ONE <<13;xj[2] = ULONG_ONE <<26;
	print();
  	vj[0]  = convert_double_to_grape_float(1.0 - 1.0/(ULONG_ONE << l),
					       INTERACTION_F_LEN_U);
	print();
    }
    /*     for(l=-512;l<512;l+=23){*/
    for(l=-128;l<128;l+=23){
	reset_inputdata();
	clear = local_clear;
	jscale = -512 - l + 24;
	vi[0]  = convert_double_to_grape_float(ldexp(1.0 + l/1000.0, l),
					       INTERACTION_F_LEN_U);
	xi[0]  = 1;
	print();
	
    }
}

void unit_s_test()
     /* drdv3*mr5inv */
{
    ULONG i, j, i1, i2;
    int k, l, m;
    int local_clear = 1;
    
    reset_data();
    testmode[3] = testmode[8] = testmode[13] = testmode[14] = 1;
    /* set values to m and vx, keep xj to 1 */
    for(l=0;l<21;l++){
	    reset_inputdata();
	    clear = 1;
	for(k=0;k<21;k++){
	    xj[0] = 1;  xj[1] = 1; xj[2] = 1;
	    jscale = -512+25;
	    vj[0]  = convert_double_to_grape_float(1.0 + 1.0/(ULONG_ONE << l),
						       INTERACTION_F_LEN_U);
	    mj  = convert_double_to_grape_float(1.0 + 1.0/(ULONG_ONE << k),
						INTERACTION_F_LEN_U);
	    print();
	    clear = 0;
	    vj[0]  = convert_double_to_grape_float(1.0 - 1.0/(ULONG_ONE << l),
						       INTERACTION_F_LEN_U);
	    mj  = convert_double_to_grape_float(-1.0 + 1.0/(ULONG_ONE << k),
						INTERACTION_F_LEN_U);
	    print();
	    
	}
    }
    /*    for(l=-512;l<512;l+=23){*/
    reset_inputdata();
    clear = 1;
    for(l=-32;l<96;l+=23){
	jscale = -512 - l + 24;
	xj[0] = 1;  xj[1] = 1; xj[2] = 1;
	vj[0]  = convert_double_to_grape_float(ldexp(1.0, l),
					       INTERACTION_F_LEN_U);
	
	mj  = convert_double_to_grape_float(-1.0 + 1.0/1000.0*l,
					    INTERACTION_F_LEN_U);
	print();
	
	mj  = convert_double_to_grape_float(ldexp(1.0+1.0/520.0*l, l),
					    INTERACTION_F_LEN_U);
	
	vj[0]  = convert_double_to_grape_float(-1.0 + 1.0/1000.0*l,
					       INTERACTION_F_LEN_U);
	print();
	
    }
}

void unit_t_test()
     /* dv[k]*mdr3inv */
{
    ULONG i, j, i1, i2;
    int k, l, m;
    int local_clear = 1;
    
    reset_data();
    testmode[3] = testmode[8] = 1;
    /* set values to m and vx, keep xj to 0 */
    for(l=0;l<21;l++){
	reset_inputdata();
	clear = 1;
	for(k=0;k<21;k++){
	    jscale = -512+25;
	    for(m=0;m<3;m++){
		vj[m]  = convert_double_to_grape_float(1.0 + 1.0/(ULONG_ONE << l),
						       INTERACTION_F_LEN_U);
	    }
	    mj  = convert_double_to_grape_float(1.0 + 1.0/(ULONG_ONE << k),
						INTERACTION_F_LEN_U);
	    print();
	    clear = 0;
	    for(m=0;m<3;m++){
		vj[m]  = convert_double_to_grape_float(1.0 - 1.0/(ULONG_ONE << l),
						       INTERACTION_F_LEN_U);
	    }
	    mj  = convert_double_to_grape_float(-1.0 + 1.0/(ULONG_ONE << k),
						INTERACTION_F_LEN_U);
	    print();
	    
	}
    }
    /*     for(l=-512;l<512;l+=23){*/
    reset_inputdata();
    clear = 1;
    for(l=-32;l<96;l+=13){
	clear = 1;
	jscale = -512 - l + 24;
	vj[0]  = convert_double_to_grape_float(ldexp(1.0, l),
					       INTERACTION_F_LEN_U);
	vj[2] = vj[1] = vj[0];
	
	mj  = convert_double_to_grape_float(-1.0 + 1.0/1000.0*l,
					    INTERACTION_F_LEN_U);
	print();
	clear = 0;
	
	mj  = convert_double_to_grape_float(ldexp(1.0+1.0/520.0*l, l),
					    INTERACTION_F_LEN_U);
	
	vj[0]  = convert_double_to_grape_float(-1.0 + 1.0/1000.0*l,
					       INTERACTION_F_LEN_U);
	vj[2] = vj[1] = vj[0];
	print();
	
    }
}

void unit_u_test()
     /* dv[k]*mdr3inv */
{
    ULONG i, j, i1, i2;
    int k, l, m;
    int local_clear = 1;
    
    reset_data();
    testmode[3] = testmode[8] = testmode[15] = 1;
    /* set values to m and xj */
    for(l=0;l<21;l++){
	for(k=0;k<21;k++){
	    reset_inputdata();
	    jscale = -512;
	    clear = local_clear;
	    for(m=0;m<3;m++){
		xj[m]  = (ULONG_ONE << 25) + (ULONG_ONE<< ((l+m)%21));
	    }
	    mj  = convert_double_to_grape_float(1.0 + 1.0/(ULONG_ONE << k),
						INTERACTION_F_LEN_U);
	    print();
	    for(m=0;m<3;m++){
		xj[m]  = (ULONG_ONE << 25) - (ULONG_ONE<< ((l+m)%21));
	    }
	    mj  = convert_double_to_grape_float(-1.0 + 1.0/(ULONG_ONE << k),
						INTERACTION_F_LEN_U);
	    print();
	    
	}
    }

    for(l=0;l<63;l+=3){
	reset_inputdata();
	clear = local_clear;
	jscale = -512 - l + 24;
	for (m=0;m<3;m++){
	    xj[m] = ULONG_ONE << l + 1;
	}	
	mj  = convert_double_to_grape_float(-1.0 + 1.0/1000.0*l,
					    INTERACTION_F_LEN_U);
	print();
	
	mj  = convert_double_to_grape_float(ldexp(1.0+1.0/520.0*l, l),
					    INTERACTION_F_LEN_U);
	
	for (m=0;m<3;m++){
	    xj[m] = ULONG_ONE << l - 1;
	}	
	print();
	
    }
}


void unit_v_test()
     /* jerk = t1 + t2 */
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;
    
    reset_data();
    testmode[2] = testmode[3] = testmode[8] =  testmode[12] =  testmode[15] = 1;
    for(l=0;l<25;l++){
	reset_inputdata();
	xj[0] = xj[1] =   xj[2] = ULONG_ONE <<25;
	jscale = -512;
	clear = local_clear;
	vj[0] =  vj[1]  = vj[2]  = convert_double_to_grape_float((double)  (ULONG_ONE<<l), INTERACTION_F_LEN_U);
	print();
	xj[0] = xj[1] =   xj[2] = ULONG_ONE <<l;
	jscale = -512;
	clear = local_clear;
	vj[0] =  vj[1]  = vj[2]  = convert_double_to_grape_float((double)  (ULONG_ONE<<25), INTERACTION_F_LEN_U);
	print();
	
    	xj[0] = xj[1] =   xj[2] = (ULONG_ONE <<25) -(ULONG_ONE<<l);
	jscale = -512;
	clear = local_clear;
	vj[0] =  vj[1]  = vj[2]  = convert_double_to_grape_float(-(double)  ((ULONG_ONE<<25)-1), INTERACTION_F_LEN_U);
	print();
    }
    
}

#define GFLOATF(x) convert_double_to_grape_float((x),INTERACTION_F_LEN_U)
#define GFLOATJ(x) convert_double_to_grape_float((x),INTERACTION_J_LEN_U)

void total_basic_test()
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;
    reset_data();
    reset_inputdata();
    mj = GFLOATF(1.0);
    fscale = -512+56;
    jscale = -512+24;
    phiscale = -512+56;
    for(k=0;k<3;k++){
	clear = local_clear;
	xj[k] = 1;
	print();
	local_clear = 0;
	xj[k] = -1;
	print();
	xj[k] = 0;
    }
    
    xj[0] = xj[1] = xj[2] = 0;

    local_clear = 1;/* New: 1998/8/6 */
    
    for(k=0;k<3;k++){
	clear = local_clear;
	xi[k] = -1;
	print();
	xi[k] = 1;
 	print();
	xi[k] = 0;
    }

    xj[0] = xj[1] = xj[2] = 1;
    for(k=0;k<3;k++){
	clear = local_clear;
	vi[k] = GFLOATF(1.0);
	print();
	vi[k] = GFLOATF(-1.0);
	print();
	xi[k] = 0;
    }
    

}

void total_rmin_test()
{
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;
    reset_data();
    reset_inputdata();
    mj = GFLOATF(1.0);
    fscale = -512+56;
    jscale = -512+24;
    phiscale = -512+56;
    for(i=0;i<20;i++){
	clear = local_clear;
	xj[0] = 1<<(20-i);
	print();
	local_clear = 0;
    }
}

void total_random_test_single(int clear_mode)
{
    double drand48();
    ULONG i, j, i1, i2;
    int k, l;
    int local_clear = 1;
    reset_data();
    reset_inputdata();
    clear = clear_mode;
    mj = GFLOATF(drand48());
    fscale = -512+48*2+48;
    jscale = -512+48*3+48;
    phiscale = -512+48+48;
    for(k=0;k<3;k++){
	xj[k] = (2*drand48()-1)*(ULONG_ONE<<48);
	xi[k] = (2*drand48()-1)*(ULONG_ONE<<48);
	vi[k] = GFLOATF((2*drand48()-1));
	vj[k] = GFLOATF((2*drand48()-1));
    }
    print();
}

void total_random_test()
{
    int k;
    int clear_mode = 1;
    srand48(12345);
    for(k=0;k<1000; k++){
	total_random_test_single(clear_mode);
    /* clear_mode = 0; New for 1998/8/6 -- neglect clear mode ... */
	
    }

}

#ifndef UNIT_TEST
#define ALLTEST 1
#define UNIT_TEST 0
#else
#define ALLTEST 0
#undef UNIT_TEST
#define UNIT_TEST 1
#endif
main()
{
    int mode;
    char test_id[128];
    test_id[0] = 0;
    print_command(FPIPE_CTAB_RESET);

    scanf("%d", &mode);
    if(mode){
	total_basic_test(); 
	total_random_test();
	total_rmin_test(); 
    }else{
#if UNIT_TEST
	scanf("%s",test_id);
	fprintf(stderr,"test_id = %s\n", test_id);
#endif
#define IFTEST(x) if((strcmp((x),test_id)==0)||ALLTEST)	
	IFTEST("a1") {
	    fprintf(stderr,"doing test a1\n");
	    unit_a_test();
	}
	IFTEST("a2") unit_a_test2();
	IFTEST("a3") unit_a_test3();
	IFTEST("a4") unit_a_test4();
	IFTEST("a5") unit_a_test5();
	IFTEST("b1") unit_b_test();

	IFTEST("c1") unit_c_test();
	IFTEST("c2") unit_c_test2();
	IFTEST("c3") unit_c1_test();
	IFTEST("c4") unit_c1_test2();
	IFTEST("c5") unit_c2_test();
	IFTEST("c6") unit_c2_test2();
	IFTEST("d1") unit_d_test();
	IFTEST("e1") unit_e_test();
	IFTEST("f1") unit_f_test();
	IFTEST("g1") unit_g_test();
	IFTEST("h1") unit_h_test();
	IFTEST("k1") unit_k_test();
	IFTEST("l1") unit_l_test();
	IFTEST("m1") unit_m_test();


	IFTEST("n1") unit_n_test();

	IFTEST("o1") unit_o_test();
	IFTEST("p1") unit_p_test(); 
	IFTEST("q1") unit_q_test(); 
	IFTEST("r1") unit_r_test(); 
	IFTEST("s1") unit_s_test(); 
	IFTEST("t1") unit_t_test(); 
	IFTEST("u1") unit_u_test(); 
	IFTEST("v1") unit_v_test();

    }

}

