//pit_particle_io.C
#include "pit_particle.h"
local int get_line(istream & s, char * line)
{
    s.get(line,MAX_INPUT_LINE_LENGTH,'\n');
    char c;
    if(s.get(c) && c!='\n'){
	cerr << "get_line : input line too long :"<<line<<endl;
	exit(1);
    }
    return strlen(line);
}

local int check_input_line(istream &s, char* reference_string)
{
    char input_line[MAX_INPUT_LINE_LENGTH];
    get_line(s,input_line);
    if(s.eof()){
	       return 99;
    }
    return !strcmp(input_line,reference_string);
}    

local int check_and_skip_input_line(istream &s, char* reference_string)
{
    char input_line[MAX_INPUT_LINE_LENGTH];
    while (! get_line(s,input_line) && !s.eof()){
        if(strcmp(input_line,reference_string) != 0 ){
	        if(s.eof()){
	        return 0;
	    }else{
	        cerr << "Input line must be "<<reference_string;
	        cerr <<", I got " << input_line << endl;
	        exit(1);
	     }
         }
          return 1;
    }    
    return 0;
}    



local void set_vector_from_input_line(vector & v, char * input_line)
{
    real vector_component[3];
    sscanf(input_line,"%*s%*s%lf%lf%lf",vector_component,
	   vector_component+1,vector_component+2);
    v=vector(vector_component[0],vector_component[1],vector_component[2]);
}


int particle::read(istream &s)
{
  char input_line[MAX_INPUT_LINE_LENGTH];
    int status = check_input_line(s, "start particle");
    if (status == 99){
        return 1;
    }
    if (!status ){
        cerr << " impossible input line ";
        exit(1);
    }
    while (strcmp((get_line(s,input_line),input_line),"end particle")!=0){
	char keyword[MAX_INPUT_LINE_LENGTH];
	char should_be_equal_sign[MAX_INPUT_LINE_LENGTH];
	sscanf(input_line, "%s%s", keyword, should_be_equal_sign);
#include "pit_particle_read_additions.C"
	if (strcmp("=", should_be_equal_sign)==0) {
            if(!strcmp("r", keyword))set_vector_from_input_line(pos,input_line);
            if(!strcmp("v", keyword))set_vector_from_input_line(vel,input_line);
            if(!strcmp("m", keyword))sscanf(input_line, "%*s%*s%lf", &mass);
            if(!strcmp("acc", keyword))set_vector_from_input_line(acc,input_line);
            if(!strcmp("pot", keyword))sscanf(input_line, "%*s%*s%lf", &pot);
            if(!strcmp("t", keyword))sscanf(input_line, "%*s%*s%lf", &time);
            if(!strcmp("dt", keyword))sscanf(input_line, "%*s%*s%lf", &timestep);
            if(!strcmp("jerk", keyword))set_vector_from_input_line(jerk,input_line);
            if(!strcmp("old_acc", keyword))set_vector_from_input_line(old_acc,input_line);
            if(!strcmp("old_jerk", keyword))set_vector_from_input_line(old_jerk,input_line);
            if(!strcmp("k_over_18", keyword))set_vector_from_input_line(k_over_18,input_line);
            if(!strcmp("pred_pos", keyword))set_vector_from_input_line(pred_pos,input_line);
            if(!strcmp("pred_vel", keyword))set_vector_from_input_line(pred_vel,input_line);
            if(!strcmp("t_pred", keyword))sscanf(input_line, "%*s%*s%lf", &t_pred);
            if(!strcmp("grape_mass", keyword))sscanf(input_line, "%*s%*s%lf", &grape_mass);
            if(!strcmp("i", keyword))sscanf(input_line, "%*s%*s%d", &index);
            if(!strcmp("grape_index", keyword))sscanf(input_line, "%*s%*s%d", &grape_index);
            if(!strcmp("isbh", keyword))sscanf(input_line, "%*s%*s%d", &isbh);
        }
    }
    return 0;
}
void particle::write(ostream &s, int olevel)
{
    s << "start particle" <<endl;
    if ((olevel >= 0)&&(0>=0)){
        s << "r = " << pos<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "v = " << vel<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "m = " << mass<<endl;
    }
    if ((olevel >= 1)&&(1>=0)){
        s << "acc = " << acc<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "pot = " << pot<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "t = " << time<<endl;
    }
    if ((olevel >= 2)&&(2>=0)){
        s << "dt = " << timestep<<endl;
    }
    if ((olevel >= 2)&&(2>=0)){
        s << "jerk = " << jerk<<endl;
    }
    if ((olevel >= 2)&&(2>=0)){
        s << "old_acc = " << old_acc<<endl;
    }
    if ((olevel >= 2)&&(2>=0)){
        s << "old_jerk = " << old_jerk<<endl;
    }
    if ((olevel >= 2)&&(2>=0)){
        s << "k_over_18 = " << k_over_18<<endl;
    }
    if ((olevel >= 2)&&(2>=0)){
        s << "pred_pos = " << pred_pos<<endl;
    }
    if ((olevel >= 2)&&(2>=0)){
        s << "pred_vel = " << pred_vel<<endl;
    }
    if ((olevel >= 2)&&(2>=0)){
        s << "t_pred = " << t_pred<<endl;
    }
    if ((olevel >= -1)&&(-1>=0)){
        s << "grape_mass = " << grape_mass<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "i = " << index<<endl;
    }
    if ((olevel >= -1)&&(-1>=0)){
        s << "grape_index = " << grape_index<<endl;
    }
    if ((olevel >= -1)&&(-1>=0)){
        s << "isbh = " << isbh<<endl;
    }
#include "pit_particle_write_additions.C"
    s << "end particle"<<endl;
}
#include "pit_particle_io_additions.C"
