#!/bin/csh -f
#
# version 2001-12-21
# Support for selection of MBUF, JPDMA and JPSPACE options added
#
# install.csh
#
# GRAPE-6 Library installation script for Linux/Alpha (for now)
#
# Supported hardwares
#
# Alphas:
# UP-1000, UP-1100, UP-2000 (Irongate and Tsunami chipsets)
#
# Alphas are tested on Linux 2.2.x and DU 4.0x only. Not on
# 2.4.x and DU 5.x (yet)
#
# Intel x86s
#
# Linux Kernel 2.2.14 and later, and 2.4.x
#
set homedir = $cwd
TOP:
cd $homedir
if ( -e install.log ) then
   set hosttype = `grep HOSTTYPE install.log | awk '{print $2}'`
else
   set hosttype = 999
endif
if (( $hosttype == 1 ) ||   ( $hosttype == 2 ) ) then
   set cputype = ALPHA
else if (( $hosttype == 3 )  ||   ( $hosttype == 5 ) ) then
   set cputype = X86
else if ( $hosttype == 4 ) then
   set cputype = ALPHA-DU
else
   set cputype = UNDEFINED
endif      
echo ========= Main Menu ========
echo 1. Compiling the device driver
echo 2. Compiling libraries and sample applications.
echo 3. Installing the device driver '(need to be a superuser)'
echo 4. Testing the basic device driver functions and the PCI card.
echo 5. Testing the libraries and sample applications
echo 6. Testing the stability of the hardware \(1\). 
echo 7. Testing the stability of the hardware \(2\). 
echo enter menu number '(1-7, or 0 to exit)':
set ans = $<
if ( $ans == 0 ) then
   exit 0
else if ( $ans == 1 ) then
   echo Compiling the device driver. 
   echo Which hardware do you have\?
   echo 1. UP-1000 and other AMD-750 based systems with Linux
   echo 2. UP-2000,DS-10,DS-20,XP-1000 and other TSUNAMI-based systems with LInux
   echo 3. Intel x86 systems with Linux 2.2.X
   echo 4. Alpha with Digital UNIX ver 4.0x
   echo 5. Intel x86 systems with Linux 2.4.X
   echo 6. None of the above
   echo enter number '(1-6)'  default=$hosttype :
   set ansh = $<
   if ( x$ansh == x ) then
      set ansh = $hosttype
   endif      
   echo HOSTTYPE $ansh >install.log
   cd ../phibdd/pcimem
   if ( $ansh == 1 ) then
       /bin/cp -p Makefile.IG Makefile
   else if ( $ansh == 2 ) then
       /bin/cp -p Makefile.TSUNAMI Makefile
   else if ( $ansh == 3 ) then
       cd ../../g6hibddx86/pcimem
   else if ( $ansh == 5 ) then
       cd ../../phibdd-2.4/pcimem
   else if ( $ansh == 4 ) then
       echo Please install the device driver for GRAPE-5.
       echo You can download it from the following URL:
       echo "http://atlas.riken.go.jp/~atsushi/grape5.html"
       echo Perhaps safer not to use too new version.
       echo I recommend version 1.0.
       echo " "
       echo NOTE: GRAPE-5 install script contains seems to have a bug
       echo which assumes that enviromental variable PWD is set.
       echo if it is not set, please set it to the current directory
       echo before you run the install script.
       echo After you finished installation of GRAPE-5 library,
       echo proceed to step 2.
       exit 1 
   else 
       echo Sorry, I do not know of these systems.
       exit 1
   endif
   if ( $ansh == 5 ) then
# now try to see if this system is AMD64 or not
      uname -a | grep x86_64
      if ( $status == 0 ) then
         echo Present system is an AMD-64 system
	 echo The present script might not work on kernels other than
	 echo 2.4.23. If you have trouble, get the kernel source from
	 echo www.kernel.org and install a new kernel.
         if ( ! -e Makefile.original)  then
	    mv Makefile Makefile.original
         endif
         uname -a | grep SMP
         if ( $status == 0 ) then
	    echo Present system is SMP
	    /bin/cp -p Makefile-AMD64SMP Makefile
	 else
	    echo Present system is not SMP
	    /bin/cp -p Makefile-AMD64NOSMP Makefile
	 endif   
      endif
   endif      
   make clean
   make  pcimem.o
   if ( $status == 0 ) then
      ls -al pcimem.o
      echo Seemingly make ended normally, return to the main menu
      echo The next step is to install the driver. Select item 2.
      goto TOP
   endif
   if ( $ansh == 5 ) then
      echo Compiling with default setup failed. Trying another...
      make -f Makefile-Slackware
      if ( $status == 0 ) then
         ls -al pcimem.o
	 echo Alternate compilation succeeded.
         echo The next step is to install the driver. Select item 2.
         goto TOP
      endif
   endif	 
   echo make failed. You might have unsupported OS, compiler or whatever
   echo Possible reasons include:
   echo "        " 1. Your gcc is not /usr/bin/gcc. Please edit Makefile.  
   echo "        " 2. Your gcc is 3.x. Well, use 2.9X.x or figure out
   echo "        "    how to compile modules with 3.X and let me know.
   exit 1

else if ( $ans == 3) then
   set hosttype = `grep HOSTTYPE install.log | awk '{print $2}'`
   echo current host type = $hosttype
   if (  `whoami` != "root" ) then
       echo You need to be a superuser to execute this part. Try again.
       exit 0
   else
       if ( $hosttype != 4 ) then
       set CARDOK = 0
       /sbin/lspci -n | grep 10b5\:9080
       if ( $status == 0 ) then
          set CARDOK = 1
          echo Card  found by  lspci
       endif	  
       cat /proc/pci | grep PCI9080
       if ( $status == 0 ) then
          set CARDOK = 1
          echo Card  found by  cat /proc/pci
       endif	  
       if ( $CARDOK == 0 ) then
          echo You have not yet installed the PCI interface card,
	  echo or your card is not properly working. Please check
	  echo your hardware configulation before proceeding
          set CARDOK = 0
	  echo DO YOU WANT TO CONINUE\? \(y/n\)
	  echo If you chose yes, the device driver itself will not
	  echo be installed, but other configuration files will.
	  echo After you have installed the card, you have to repeat
	  echo this step anyway.
          set ans = $<
	  if ( $ans != y ) then
	      exit -1
	  endif    
       endif
       endif
       echo Where to install the device driver module and other files\?\(/usr/local/lib\)
       echo Note that header files are installed at x/../include. For example,
       echo default location for the header file is /usr/local/include.
       set dir = $<
       if ( x$dir == x ) set dir = /usr/local/lib
       if ( ! ( -e $dir ) ) then
           echo directory $dir not there. creating one...
	   mkdir $dir
       else
           echo directory $dir exists.
       endif	   
       if ( ! ( -e $dir/../include ) ) then
           echo directory $dir/../include  not there. creating one...
	   mkdir $dir/../include
       else
           echo directory $dir/../include exists.
       endif	   
       echo Place to install the module is $dir
       if ( $hosttype != 4 ) then
       if ( $CARDOK == 1 ) then
       echo You seem to have at least one GRAPE-6 interface card.
       if (( $hosttype == 1 )|( $hosttype == 2) ) then
          cp -pi ../phibdd/pcimem/pcimem.o $dir
       else if ( $hosttype == 3 ) then
          cp -pi ../g6hibddx86/pcimem/pcimem.o $dir
       else if ( $hosttype == 5 ) then
          cp -pi ../phibdd-2.4/pcimem/pcimem.o $dir
       else
          echo UNKNOWN HOSTTYPE $hosttype
	  echo Please try step 1 again to compile a proper device driver
       endif       	  
       ls -al  $dir/pcimem.o
       echo if you see $dir/pcimem.o above, instalation is okay.
       /sbin/insmod -f   $dir/pcimem.o
       cat /proc/devices | grep pcimem
       if ( $status != 0 ) then
          echo insmod failed for unknown reason. Contact us.
	  exit 1
       endif
       set majorid = `cat /proc/devices | grep pcimem|awk '{print $1}'`
       mknod -m og+rw /dev/pcimem0 c $majorid 0
       ls -al /dev/pcimem0
       if ( $status != 0 ) then
          echo Failed to create the device special file... 
	  exit 1
       endif
       echo Creation of the device special file ended normally
       echo Adding the insmod command to a boot file
       if ( -e /sbin/init.d/boot.local ) then
          set bootfile = /sbin/init.d/boot.local
       else if (  -e /etc/rc.d/boot.local ) then
          set bootfile = /etc/rc.d/boot.local
       else if (  -e /etc/rc.d/rc.local ) then
          set bootfile = /etc/rc.d/rc.local
       else
          echo Sorry, I could not figure out where is your boot.local file.
          echo You have to add the command
          echo /sbin/insmod -f   $dir/pcimem.o
          echo somewhere so that it is executed at booting,
          echo or you can do it manually after each boot.
          exit 1
       endif      
       grep pcimem $bootfile
       if ( $status == 0 ) then
          echo You seem to have added the insmod command already.
	  echo So no need to edit this file.
       else
          echo Preserving the original $bootfile ${bootfile}.bak
          cp -pi 	$bootfile  ${bootfile}.bak
          echo adding new stuff
          echo /sbin/insmod -f   $dir/pcimem.o >> $bootfile
          tail  $bootfile
       endif
       endif
       endif
       echo copying FPGA design files to $dir/grape6
       mkdir $dir/grape6
       cp -rp ../grape6board $dir/grape6
       echo copying libraries
       cp -pi ../*/*.a  $dir
       echo copying headers
       if ( ! ( -e $dir/../include ) ) then
           mkdir $dir/../include
       endif	   
       cp -pi ../g6hib-x86/grape6.h  $dir/../include
       echo installing the configulation file
       echo Which clocking scheme do you use\?\(0,1\)
       echo 0: board EPROM before DEC 2001
       echo 1: board EPROM after  DEC 2001
       set ckscheme = $<
       if ( x$ckscheme == x1 ) then
           echo Using board EPROM later than DEC 2001
       endif	   
       echo Which PCI card version do you use\?\(0,1\)
       echo 0: card EPROM before DEC 2001
       echo 1: card EPROM after  DEC 2001
       set pcischeme = $<
       if ( x$pcischeme == x1 ) then
           echo Using card EPROM later than DEC 2001
       endif	   
       echo How many modules do you have\? \(1,2,4 or 8\)
       set nmod = $<
       (echo NEWPATH $dir/grape6 ; cat g6config_export${nmod}.dat0) |\
          awk -f editconfpath.awk > $dir/grape6/g6config.dat0
       if ( x$ckscheme == x1 ) then
           echo MBUFTYPE Fairchild-LCX16374A-V3 >> $dir/grape6/g6config.dat0
       endif
       if ( x$pcischeme == x1 ) then
           echo JPSPACE 12 >> $dir/grape6/g6config.dat0
           echo IJPDMA 1 >> $dir/grape6/g6config.dat0
       endif
       chmod og+r 	   $dir/grape6/g6config.dat0
       (echo NEWPATH $dir/grape6 ; cat g6config_export_oldcard.dat0) |\
          awk -f editconfpath.awk > $dir/grape6/g6config_oldcard.dat0
       chmod og+r 	   $dir/grape6/g6config_oldcard.dat0
       ls -al 	   $dir/grape6/g6config.dat0
       echo The configulation file is installed at $dir/grape6/
       echo Define eivironmental variable GRAPE6_CONFIG_FILE as  $dir/grape6/g6config.dat
       echo before using GRAPE-6. With csh and its variants, you would add
       echo setenv GRAPE6_CONFIG_FILE $dir/grape6/g6config.dat
       echo in your .cshrc file. 
       exit 0
   endif
else if ( $ans == 4 ) then
   echo Tesing basic function of PCI card
   if (( $hosttype == 1 )|( $hosttype == 2) |( $hosttype == 4) ) then
      cd ../phibdd/phib
   else if ( $hosttype == 3 ) then
      cd ../g6hibddx86/phib
   else if ( $hosttype == 5 ) then
      cd ../phibdd-2.4/phib
   else
      echo UNKNOWN HOSTTYPE $hosttype
      echo Please try step 1 again to compile a proper device driver
   endif       	  
   make clean 
   make phibtest
   ./phibtest 7
   echo =====================
   echo You should see something like the following:
cat <<EOF         
# of clusters: 1
bar2: 0x0b100000
offset: 0x00000000
devid, mptr(0) = 0 20000020000 0 2000
devid, rptr = 0 2000002f000
TBdmaMapLoad() not implemented yet.
## phib0:
## configration register:
0x00000000: 0x908010b5
0x00000004: 0x02800007
0x00000008: 0xffffff03
0x0000000c: 0x0000ff10
0x00000010: 0x0b10f000
0x00000014: 0x00009801
0x00000018: 0x0b100008
0x0000001c: 0x00000000
0x00000020: 0x00000000
0x00000024: 0x00000000
0x00000028: 0x00000000
0x0000002c: 0x908010b5
0x00000030: 0x00000000
0x00000034: 0x00000000
0x00000038: 0x00000000
0x0000003c: 0x00000000

## PCI9080 local register:
0x00000000: 0xfff00008
0x00000004: 0x00000001
0x00000008: 0x00000000
0x0000000c: 0x00000000
0x00000010: 0x00000000
0x00000014: 0x00000000
0x00000018: 0x490300c3
0x0000001c: 0x00000000
0x00000020: 0x00000000
0x00000024: 0x00000000
0x00000028: 0x00000000
0x0000002c: 0x00000000
EOF
   echo If you have seen, e.g., all f or something strange,
   echo it is likely that your PCI card is not correctly installed
   echo or you have chosen the wrong hardware when compiling the
   echo device driver. Check your hardware and try again.
   echo ""
   echo If you have Digital UNIX  host, this step fails.
   echo You can either try to run phibtest in GRAPE-5 library
   echo or proceed to step 5.
   goto TOP
else if ( $ans == 2 ) then
   echo Compiling libraries and basic hardware test routines
   if ( $cputype == ALPHA) then
     echo for an ALPHA CPU with LINUX
      cd ../grape6
      make -f Makefile.linuxalpha
      cd ../g6hib
      make -f Makefile.linuxalpha
      echo Compiling a simple shared-timestep program
      cd ../simple-grape
      make -f Makefile.g6linux
      cd ../grape
      make -f Makefile.g6linux grape6
      echo Compiling an individual timestep program
      cd ../pit
      make -f Makefile.la pit pit_grape6
   else if  ( $cputype == X86) then
      echo for an INTEL CPU
      cd ../grape6-x86
      make -f Makefile
      cd ../g6hib-x86
      make -f Makefile
      echo Compiling a simple shared-timestep program
      cd ../simple-grape
      make -f Makefile.g6lx
      cd ../grape
      make -f Makefile.g6lx grape6_lx
      echo Compiling an individual timestep program
      cd ../pit
      make -f Makefile.lx pit_lx pit_grape6_lx
      ln pit_grape6_lx pit_grape6
   else if  ( $cputype == ALPHA-DU) then
      echo for an ALPHA CPU with Digital UNIX
      cd ../grape6
      make -f Makefile
      cd ../g6hib
      make -f Makefile
      echo Compiling a simple shared-timestep program
      cd ../simple-grape
      make -f Makefile
      cd ../grape
      make -f Makefile.grape6 grape6
      echo Compiling an individual timestep program
      cd ../pit
      make -f Makefile pit pit_grape6
   endif      
   echo  You will need
   echo to be the superuser. Become superuser and run this
   echo  script again, and select menu item 3.
else if ( $ans == 5 ) then
   if ( x$GRAPE6_CONFIG_FILE  == x ) then
      echo env. var.  GRAPE6_CONFIG_FILE is not set.
      What path do you want\? \(/usr/local/lib/grape6\)
      set confpath = $<
      if ( x$confpath == x ) then
         set confpath = /usr/local/lib/grape6
      endif	 
      setenv GRAPE6_CONFIG_FILE $confpath/g6config.dat
    endif
    echo First perform a basic hardware test
    if ( ( $cputype == ALPHA ) | ( $cputype == ALPHA-DU ) ) then
       ./g6libtest
    else
       ../g6hib-x86/g6libtest
    endif   
    echo ==============
    echo If the last few lines are
    cat <<EOF
--------------------------------------------------------
i:   98 acc: 1.543803e-01  9.378149e-01  1.686262e+00 
          jerk 2.547520e+00  -5.586433e-02  -8.773594e-01 
 pot, flag: -1.610577e+00 0
i:   99 acc: -1.339726e+00  8.797277e-01  2.482933e-01 
          jerk -2.699718e-01  -6.660347e-01  -6.509800e-01 
 pot, flag: -1.403734e+00 0
--------------------------------------------------------
EOF
   echo The hardware seems to have passed the  first test.
   echo We now proceed to the second test. \(press return\)
   set y = $<
   cd ../simple-grape
   if ( $cputype == ALPHA ) then
      ./grape6 < testparm
       echo ==============
       echo If the last few lines are
       cat <<EOF
--------------------------------------------------------
T=       5.000  E =    -0.253148379  
DE=-4.71895792e-04  V.R. =   0.497748
CM : 1.36325e-16 -4.92634e-18 -9.92045e-18
CMV: 4.43778e-17  4.87891e-19  8.53809e-18
AM : 5.19160e-03 -3.95216e-03  3.94282e-04
Exit  diag:CPU sec.=       17.90
--------------------------------------------------------
EOF
   else
      ./grape6_lx < testparm
       echo ==============
       echo If the last few lines are
       cat <<EOF
--------------------------------------------------------
T=       5.000  E =    -0.253148379  
DE=-4.71895818e-04  V.R. =   0.497748
CM : 1.54038e-16 -5.55654e-18  3.97767e-18
CMV: 3.36441e-17  1.92446e-17  1.66696e-17
AM : 5.19160e-03 -3.95216e-03  3.94282e-04
--------------------------------------------------------
EOF
   endif
   echo The hardware seems to have passed the secnd test.
   echo We now proceed to the third test. \(press return\)
   set y = $<
   cd ../pit
   if ( $cputype == ALPHA ) then
      ./pit_grape6  -i test128
       echo ==============
       echo If the last few lines are
       cat <<EOF
--------------------------------------------------------
Time= 10 N= 128
Energies(KE,PE,ETOT)=  0.285875491216492972  -0.541724041871020745  -0.255848550654527773;  de = 1.1852968733585655e-07
CMPOS= -1.00970527835021057e-07  1.39665046383977143e-07  -2.59323243356410216e-08
CMV = -3.30218132699178213e-09  1.92807652241947652e-08  -6.03574519661073672e-09
steps = 216652 Bsteps = 14734 CPU time 10.146484375
--------------------------------------------------------
EOF
   else
   ./pit_grape6_lx  -i test128
       echo ==============
       echo If the last few lines are
       cat <<EOF
--------------------------------------------------------
Time= 10 N= 128
Energies(KE,PE,ETOT)=  0.27863364627592152  -0.534482192048017168  -0.255848545772095648;  de = 9.94463990888330244e-08
CMPOS= -1.11820454694756127e-07  1.3007831151101712e-07  -2.05825519180441452e-08
CMV = -1.01913972538891784e-08  1.93515003272994729e-08  3.21462929496127425e-09
steps = 215288 Bsteps = 14486 CPU time 9.71000000000000085
--------------------------------------------------------
EOF
   endif
   echo The hardware seems to have passed the Third test.
   echo This is the end of the pre-configured test.
   echo Note that if you have x86 and Linux 2.4.x this test may fail,
   echo but that does not mean hardware problem.
else if ( $ans == 6 ) then
    echo Hardware test 1. This may take a long time.
    echo Try this option twice and compare the results.
    cd ../grape
    echo How many modules do you have\? \(1,2,4 or 8\)
    set nmod = $<
    set n = `echo $nmod | awk '{print $1 * 50000}'`
    echo N = $n
    csh -f g6ltest.csh $n 50
else if ( $ans == 7 ) then
    echo Hardware test 2. This may take a long time.
    echo Try this option twice and compare the results.
    cd ../pit
if ( `uname` == OSF1 ) then
   set exe = pit_grape6
else     if ( `uname` == Linux ) then
   if  ( `arch` == alpha ) then
       set exe = pit_grape6
   else
       set exe = pit_grape6_lx
   endif
endif   
    $exe -i test32768
endif
    
     

