/*
 * convert_forcepipe_vector.c
 *
 * convert the test vector for the single force pipeline
 * made by forcepipe.c to chip test vector format
 *
 * Copyright Jun Makino 1998
 *
 * Version 1.0 1998/08/05
 */
#include "grape6sim.h"
#include "g6chip.h"
#include "g6control.h"

#define MAXSTR 1024

#define MAXPATTERNS 2048

static char patterns[MAXPATTERNS][MAXSTR];
static int npatterns = 0;
struct chip_control_struct * cu_ptr;

void generate_test_input_from_pipe_pattern();

void set_cutoff_from_str(char * instr)
{
    int addr, d1,d2,d3,d4,d5,d6;
    int ndata;
    if (npatterns) {
	generate_test_input_from_pipe_pattern();
	npatterns = 0;
    }
    ndata=sscanf(instr+4,"%x%x%x%x%x%x%x",
		 &addr,&d1,&d2,&d3,&d4,&d5,&d6);
    if(ndata != 7){
	fprintf(stderr,"set cutoff_from_str, strange input line %s\n",
		instr);
	exit(-1);
    }
    set_cutoff_table_data(d1,0,0,addr);
    set_cutoff_table_data(d2,1,0,addr);
    set_cutoff_table_data(d3,2,0,addr);
    set_cutoff_table_data(d4,0,1,addr);
    set_cutoff_table_data(d5,1,1,addr);
    set_cutoff_table_data(d6,2,1,addr);
    if (addr == 0x3f){
	     dump_cutoff_table();
	     dump_cutoff_table_in_host_port(cu_ptr);
    }
}

ULONG xj[3], vj[3],mj,xi[3],vi[3],pindex,iindex,eps2,h2,
    rscale, fscale, jscale,phiscale,clear,
    testmode[16],acc[3],jerk[3],phi,nbflag,rmin,pmin,accstatus[7];

static struct gchip g6chip;
int read_chipstate_str(char * instr)
{
    static char dumstr[100];
    static int first_clear = 1;
    int ndata;
    int i;
    ndata = sscanf(instr+3,
		   "%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%s%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx%lx",
		   xj,xj+1,xj+2, /* 3 */
		   vj,vj+1,vj+2, &mj, /* 7 */
		   xi, xi+1, xi+2,  /* 10 */
		   vi, vi+1, vi+2, /* 13 */
		   &pindex, &iindex, &eps2, &h2,  /* 17 */
		   &rscale, &fscale, &jscale, &phiscale,&clear, /* 22 */
		   testmode+1,testmode+2,testmode+3,testmode+4,testmode+5,
		   testmode+6,testmode+7,testmode+8,testmode+9,testmode+10,
		   testmode+11,testmode+12,testmode+13,testmode+14,testmode+15,
		   /* 37 */
		   dumstr, /*38 */
		   acc,acc+1,acc+2, 		  /* 41 */
		   jerk,jerk+1,jerk+2,&phi,  /* 45 */
		   &nbflag, &rmin, &pmin, /*48*/
		   accstatus,accstatus+1,accstatus+2,accstatus+3,
		   accstatus+4,accstatus+5,accstatus+6) ;/*55 */
    if (ndata != 55){
	fprintf(stderr,"set chipstate_from_str, %d, strange input line %s\n",
		ndata,instr);
	exit(-1);
    }
    printf("test modes = ");
    for(i=0;i<16;i++)printf(" %1d",testmode[i]);
    printf("\n");
    return clear;
    
}


void generate_test_input_from_pipe_pattern()
{
    int i,j,k,l;
    struct jparticle * jp;
    struct iparticle * ip;
    /* first set jparticles */
    printf("generate_test, npatterns= %d\n", npatterns);
    for(i=0;i<npatterns;i++){
	ULONG sign, exponent, mantissa, zero;
	int signed_exp;
	j = npatterns - 1 - i;
	read_chipstate_str(patterns[i]);
	jp = g6jpmem_ptr()+j;
	jp->mass = mj;
	jp->index = pindex;
	jp->tjlsb = 0;
	jp->dtjmsb = 32;
	for(k=0;k<3;k++){
	    jp->ix[k][0] = xj[k];
	    /* velocity part requires the conversion from grape float
	       format to predictor velocity format */
	    decompose_float(vj[k], INTERACTION_F_LEN_U,
			    &exponent, &sign, &zero, &mantissa);
	    if(zero == 1) mantissa = 0;
	    signed_exp = exponent;
	    exponent = exponent - INTERACTION_POSITION_EXP_OFFSET+jp->dtjmsb;
	    exponent = exponent & 0x7fL;

	    jp->ix[k][1] = (exponent<<25)|(sign<<24)|mantissa;
	    for(l=2;l<5;l++)jp->ix[k][l] = 0;
	}
	printf("generate_test: print vector for particle %d\n",j);
	printf("generate_test, i, j, input = %d %d\n",i,j);
	put_jpport_data(j, jp, cu_ptr);
    }
    /* then set iparticles : put same data to all of 48 pipelines */
    ip = &(g6chip.inreg[0]);
    for(k=0;k<3;k++){
	ip->xi[k] = xi[k];
	ip->vi[k] = vi[k];
    }
    ip->eps2 = eps2;
    ip->h2 = h2;
    ip->rscale = rscale;
    ip->fscale = fscale ;
    ip->jscale = jscale ;
    ip->phiscale = phiscale;
    ip->index = iindex;
    for (i=1;i<NPIPEPERCHIP;i++){
	*(ip+i) = *ip;
    }
    set_debug_level(0);
    set_g6chip_nip(16);
    set_forcepipe_testmode(testmode);
    set_forcepipe_testpattern_mode(1);
    set_njp(npatterns);
    run_chip(&g6chip);
}
	

void set_chipstate_from_str(char * instr)
{
    static int first_clear = 1;
    if(read_chipstate_str(instr)){
	if (first_clear == 0){
	    generate_test_input_from_pipe_pattern();
	}
	first_clear = 0;
	npatterns = 0;
    }
    if(strlen(instr) >= MAXSTR){
	fprintf(stderr,"String length %d for %s too long\n",
		strlen(instr), instr);
	exit(-1);
    }
    strcpy(patterns[npatterns],instr);
    npatterns ++;
}



static char instr[MAXSTR];

main()
{
    cu_ptr = g6cu_ptr();
    init_g6sim();
    while(gets(instr) != NULL){
	if(strncmp("CUT ",instr,4)==0){
	    set_cutoff_from_str(instr);
	}
	if(strncmp("IN= ",instr,3)==0){
	    set_chipstate_from_str(instr);
	}
    }
    if (npatterns) generate_test_input_from_pipe_pattern();    
}

