//pit_system_io.C
#include "pit_system.h"
local int get_line(istream & s, char * line)
{
    s.get(line,MAX_INPUT_LINE_LENGTH,'\n');
    char c;
    if(s.get(c) && c!='\n'){
	cerr << "get_line : input line too long :"<<line<<endl;
	exit(1);
    }
    return strlen(line);
}

local int check_input_line(istream &s, char* reference_string)
{
    char input_line[MAX_INPUT_LINE_LENGTH];
    get_line(s,input_line);
    if(s.eof()){
	       return 99;
    }
    return !strcmp(input_line,reference_string);
}    

local int check_and_skip_input_line(istream &s, char* reference_string)
{
    char input_line[MAX_INPUT_LINE_LENGTH];
    while (! get_line(s,input_line) && !s.eof()){
        if(strcmp(input_line,reference_string) != 0 ){
	        if(s.eof()){
	        return 0;
	    }else{
	        cerr << "Input line must be "<<reference_string;
	        cerr <<", I got " << input_line << endl;
	        exit(1);
	     }
         }
          return 1;
    }    
    return 0;
}    



local void set_vector_from_input_line(vector & v, char * input_line)
{
    real vector_component[3];
    sscanf(input_line,"%*s%*s%lf%lf%lf",vector_component,
	   vector_component+1,vector_component+2);
    v=vector(vector_component[0],vector_component[1],vector_component[2]);
}


int particle_system::read(istream &s)
{
  char input_line[MAX_INPUT_LINE_LENGTH];
    int status = check_input_line(s, "start particle_system");
    if (status == 99){
        return 1;
    }
    if (!status ){
        cerr << " impossible input line ";
        exit(1);
    }
    while (strcmp((get_line(s,input_line),input_line),"end particle_system")!=0){
	char keyword[MAX_INPUT_LINE_LENGTH];
	char should_be_equal_sign[MAX_INPUT_LINE_LENGTH];
	sscanf(input_line, "%s%s", keyword, should_be_equal_sign);
#include "pit_system_read_additions.C"
	if (strcmp("=", should_be_equal_sign)==0) {
            if(!strcmp("nsize", keyword))sscanf(input_line, "%*s%*s%d", &nsize);
            if(!strcmp("n", keyword))sscanf(input_line, "%*s%*s%d", &n);
            if(!strcmp("nbh", keyword))sscanf(input_line, "%*s%*s%d", &nbh);
            if(!strcmp("time", keyword))sscanf(input_line, "%*s%*s%lf", &time);
            if(!strcmp("t_end", keyword))sscanf(input_line, "%*s%*s%lf", &t_end);
            if(!strcmp("eta", keyword))sscanf(input_line, "%*s%*s%lf", &eta);
            if(!strcmp("eps2", keyword))sscanf(input_line, "%*s%*s%lf", &eps2);
            if(!strcmp("pos", keyword))set_vector_from_input_line(pos,input_line);
            if(!strcmp("vel", keyword))set_vector_from_input_line(vel,input_line);
            if(!strcmp("mass", keyword))sscanf(input_line, "%*s%*s%lf", &mass);
            if(!strcmp("max_timestep", keyword))sscanf(input_line, "%*s%*s%lf", &max_timestep);
            if(!strcmp("t_snap_next", keyword))sscanf(input_line, "%*s%*s%lf", &t_snap_next);
            if(!strcmp("dt_snap_next", keyword))sscanf(input_line, "%*s%*s%lf", &dt_snap_next);
            if(!strcmp("t_log_next", keyword))sscanf(input_line, "%*s%*s%lf", &t_log_next);
            if(!strcmp("dt_log_next", keyword))sscanf(input_line, "%*s%*s%lf", &dt_log_next);
            if(!strcmp("ntsize", keyword))sscanf(input_line, "%*s%*s%d", &ntsize);
            if(!strcmp("nprev", keyword))sscanf(input_line, "%*s%*s%d", &nprev);
            if(!strcmp("nupdated", keyword))sscanf(input_line, "%*s%*s%d", &nupdated);
            if(!strcmp("step_count", keyword))sscanf(input_line, "%*s%*s%lf", &step_count);
            if(!strcmp("MP_step_count", keyword))sscanf(input_line, "%*s%*s%lf", &MP_step_count);
            if(!strcmp("blockstep_count", keyword))sscanf(input_line, "%*s%*s%d", &blockstep_count);
            if(!strcmp("grape_steps", keyword))sscanf(input_line, "%*s%*s%d", &grape_steps);
            if(!strcmp("snapflag", keyword))sscanf(input_line, "%*s%*s%d", &snapflag);
            if(!strcmp("dumpflag", keyword))sscanf(input_line, "%*s%*s%d", &dumpflag);
            if(!strcmp("nprocessors", keyword))sscanf(input_line, "%*s%*s%d", &nprocessors);
            if(!strcmp("myprocid", keyword))sscanf(input_line, "%*s%*s%d", &myprocid);
            if(!strcmp("grape_nclusters", keyword))sscanf(input_line, "%*s%*s%d", &grape_nclusters);
            if(!strcmp("grape_firstcluster", keyword))sscanf(input_line, "%*s%*s%d", &grape_firstcluster);
        }
    }
    return 0;
}
void particle_system::write(ostream &s, int olevel)
{
    s << "start particle_system" <<endl;
    if ((olevel >= 0)&&(0>=0)){
        s << "nsize = " << nsize<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "n = " << n<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "nbh = " << nbh<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "time = " << time<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "t_end = " << t_end<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "eta = " << eta<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "eps2 = " << eps2<<endl;
    }
    if ((olevel >= 1)&&(1>=0)){
        s << "pos = " << pos<<endl;
    }
    if ((olevel >= 1)&&(1>=0)){
        s << "vel = " << vel<<endl;
    }
    if ((olevel >= 1)&&(1>=0)){
        s << "mass = " << mass<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "max_timestep = " << max_timestep<<endl;
    }
    if ((olevel >= 1)&&(1>=0)){
        s << "t_snap_next = " << t_snap_next<<endl;
    }
    if ((olevel >= 1)&&(1>=0)){
        s << "dt_snap_next = " << dt_snap_next<<endl;
    }
    if ((olevel >= 1)&&(1>=0)){
        s << "t_log_next = " << t_log_next<<endl;
    }
    if ((olevel >= 1)&&(1>=0)){
        s << "dt_log_next = " << dt_log_next<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "ntsize = " << ntsize<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "nprev = " << nprev<<endl;
    }
    if ((olevel >= -1)&&(-1>=0)){
        s << "nupdated = " << nupdated<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "step_count = " << step_count<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "MP_step_count = " << MP_step_count<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "blockstep_count = " << blockstep_count<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "grape_steps = " << grape_steps<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "snapflag = " << snapflag<<endl;
    }
    if ((olevel >= 0)&&(0>=0)){
        s << "dumpflag = " << dumpflag<<endl;
    }
    if ((olevel >= -1)&&(-1>=0)){
        s << "nprocessors = " << nprocessors<<endl;
    }
    if ((olevel >= -1)&&(-1>=0)){
        s << "myprocid = " << myprocid<<endl;
    }
    if ((olevel >= -1)&&(-1>=0)){
        s << "grape_nclusters = " << grape_nclusters<<endl;
    }
    if ((olevel >= -1)&&(-1>=0)){
        s << "grape_firstcluster = " << grape_firstcluster<<endl;
    }
#include "pit_system_write_additions.C"
    s << "end particle_system"<<endl;
}
#include "pit_system_io_additions.C"
