/*
 *
 * randomtest.c : generate pseudo-random test vector;
 *
 * output : testgen input format (hex mode/decimal mode)
 *
 */

#include <stdio.h>
#include <sys/ieeefp.h>
#include <floatingpoint.h>

print_header()
{
#ifdef HEXOUT
    printf("HEX\n");
#else
    printf("DEC\n");
#endif
}

#ifndef MANTEST
print_random_float()
{
    unsigned int i;
    unsigned int j;
    float *x = (float*)&i;
    while(i=random(),!isnormal(*x));
        j = random();
        i = i | ((j>>8)<<31);
#ifndef HEXOUT    
    printf(" %20.12g", *x);
#else
    printf(" %8x", i);
#endif    
}
print_random_double()
{
    double x;
    unsigned int * i;
    float f;
    unsigned int j;
    i = (unsigned int*)&x;
    while(*i=random(), *(i+1)=random(),f=x,!isnormal(f));
        j = random();
        *i |= ((j>>8)<<31);
        j = random();
        *(i+1) |= ((j>>8)<<31);
#ifndef HEXOUT    
    printf(" %26.18g", x);
#else
    printf(" %8x %8x", *i, *(i+1));
#endif    
}
#else /* MANTEST - all input values are in (-1,1) */
print_random_float()
{
    unsigned int i,j;
    float x;
    double xx;
    double scalbn();
    i=random();
    j = random();
    i = i | ((j>>8)<<31);
    fprintf(stderr,"i = %x\n", i);
    i |= 0x7f800000;
    i &= 0xbfffffff;
#ifndef HEXOUT    
    printf(" %20.12g", *((float*) &i));
#else
    printf(" %8x", i);
#endif    
}
print_random_double()
{
    double x;
    unsigned int * i;
    float f;
    unsigned int j;
    i = (unsigned int*)&x;
    *i=random();
    *(i+1)=random();
    j = random();
    *i |= ((j>>8)<<31);
    j = random();
    *(i+1) |= ((j>>8)<<31);
    *i |= 0x3ff00000;
    *i &= 0xbfffffff;
#ifndef HEXOUT    
    printf(" %26.18g", x);
#else
    printf(" %8x %8x", *i, *(i+1));
#endif    
}
#endif


    
print_random_vector()
{
    print_random_double();
    print_random_double();
    print_random_double();
    print_random_float();
    print_random_float();
    print_random_float();
    print_random_float();
    printf("\n");
}
void main(argc, argv)
    int argc;
    char** argv;
{
    int seed = 12345;
    int nvector;
    int i;
    
    fprintf(stderr,"argc = %d\n", argc);
    if(argc < 2){
	fprintf(stderr,"usage : randomtest n_vector [seed]\n");
	exit(1);
    }
    sscanf(*(argv+1),"%d", &nvector);
    fprintf(stderr,"N_vector = %d\n", nvector);
    
    if(argc>=3){
	sscanf(*(argv+2),"%d", &seed);
	fprintf(stderr,"New seed = %d\n", seed);
    }
    srandom(seed);
    print_header();
    for(i=0;i<nvector;i++){
	fprintf(stderr,"i : %d\n", i);
	print_random_vector();
    }
}
    
