#ifdef HARP3
#define GRAPE
#endif
#ifdef GRAPE6
#define GRAPE
#endif
#ifdef GRAPE5
#define GRAPE
#endif
// 
// BHtree.C
// Version 1999/1/1 --- cleaned up and some comments  added.
//
// The tree construction/handling package designed for TREE
// implementation of SPH/NBODY programs
//
//
// This program uses a new tree construction method, based on
// Morton ordering and top-down tree construction.
//
// non-local functions (not complete yet...)
//
// setup_tree()
//    allocate the memory for tree if necessary
//    create the tree structure
// set_cm_quantities_for_default_tree()
//    calculate mass and position for tree nodes
//
// set_hmax_for_sph() (SPH use only)
// check_and_set_nbl() (SPH use only)
//
// calculate_gravity_using_tree() (NO GRAPE)
//
// evaluate_gravity_using_tree_and_list()(GRAPE)

extern "C" double cpusec();

#define NCRIT_FOR_TREE 8

#include  <unistd.h>
#include  <stdlib.h>
#include  <math.h>


#define PR(x)  cerr << #x << " = " << x << " "
#define PRC(x) cerr << #x << " = " << x << ",  "
#define PRL(x) cerr << #x << " = " << x << "\n"
#define PRCI(x) cerr << "ID " << MP_myprocid() << " " << #x << " = " << x << ",  "
#define PRLI(x) cerr << "ID " << MP_myprocid() << " " << #x << " = " << x << endl;


#ifdef ICC
#include  <iostream>
using namespace std;
#else
#include  <stdiostream.h>
#endif


#define real double
#include "BHtree.h"
#include "nbody.h"

void dump_octal(BHlong x)
{
    char st[256];
    sprintf(st," %lo ",x);
    cerr <<  st ;
}

    


int init_bhp(int nbody,
		    real_particle * rp,
		    int & nbhpsize,
		    bhparticle * &bhp)
{
    int retval =0;
    if (nbody > nbhpsize || bhp == NULL){
	retval = 1;
	if (bhp != NULL){
	    delete [] bhp;
	}
	nbhpsize = arraysize(nbody);
	bhp = new bhparticle[nbhpsize];
    }
    for(int i = 0; i<nbody; i++){
	bhparticle * p = bhp + i;
	p->set_rp(rp+i);
    }
    retval;
}
real maxbox(int nbody,
	    real_particle * rp)
{
    real rmax = 1;
    for(int i = 0; i<nbody; i++){
	vector p = (rp+i)->get_pos();
	for (int k = 0; k<3; k++){
	    if (fabs(p[k])>=rmax) rmax *= 2;
	}
    }
    return rmax;
}
real initialize_bhp(int nbody,
		    real_particle * rp,
		    int & nbhpsize,
		    bhparticle * &bhp)
{
    init_bhp(nbody, rp, nbhpsize,bhp);
    return maxbox(nbody,rp);
}

void bhnode::assign_root(vector root_pos, real length, bhparticle * bp, int np)
{
    pos = root_pos;
    l = length;
    bpfirst = bp;
    nparticle = np;
    for(int i = 0;i<8;i++)child[i] = NULL;  
}


    


void spc(int indent)
{
    for(int i=0;i<indent;i++)cerr << " ";
}

void bhnode::dump(int indent)
{
    int i;
    spc(indent); cerr << "node pos " << pos ;
#ifdef SPH    
    cerr << " h " << hmax_for_sph;
#endif
    cerr << endl;
    spc(indent); cerr << "node cm  " << cmpos << " m " << cmmass ;
    if (isleaf){
	cerr << " IS LEAF" ;PRL(nparticle);
	bhparticle * bp = bpfirst;
	for(i = 0; i < nparticle; i++){
	    for(int j=0;j<indent+2;j++)cerr << " ";
	    real_particle * p = bp->get_rp();
	    PR(p->get_index()); PRL(p->get_pos());
	    bp=bp->get_bhp_next();
	}
    }else{
	cerr << " IS _not_ LEAF ";PRL(nparticle);
	for(i=0;i<8;i++){
	    if (child[i] != NULL){
		child[i]->dump(indent + 2);
	    }
	}
    }
}

// inbox: returns 0 if the particle is in the box;

int inbox(vector  & cpos, // center of the box
	  vector  & pos,  // position of the particle
	  real l)         // length of one side of the box
    
{
    for(int  i = 0; i< ndim; i++){
	if (fabs(pos[i]-cpos[i]) > l*0.5) return 1;
    }
    return 0;
}
	
	
int bhnode::sanity_check()
{
    int i;
    int iret = 0;
    if (isleaf){
	// this is the lowest level node. Things to check:
	// all particles are in the cell
	bhparticle * bp = bpfirst;
	cout << "Leaf np="<< nparticle <<endl;
	for(i = 0; i < nparticle; i++){
	    real_particle * p = bp->get_rp();
	    vector ppos = p->get_pos();
	    if(inbox(pos,ppos,l)){
		cerr << "Error, particle out of box ... \n";
		dump();
		return 1;
	    }
	    bp=bp->get_bhp_next();
	}
    }else{

	// This is the non-leaf node. Check the position and side
	// length of the child cells and then check recursively..
	cout << "Non Leaf " << pos  <<endl;
	for(i=0;i<8;i++){
	    if (child[i] != NULL){
		int err = 0;
	        err = child[i]->sanity_check();
		if (l*0.5 != child[i]->get_length()) err += 2;
		vector relpos = pos-child[i]->get_pos();
		for (int k = 0 ; k<ndim;k++){
		    if (fabs(relpos[k]) !=l*0.25)err += 4;
		}
		if (err){
		    cerr << "Child " << i << " Error type = " << err << endl;
		    dump();
		}
		iret += err;
	    }
	}
    }
    return iret;
}

#ifdef SPH	
void  bhnode::set_hmax_for_sph()
{
    int i;
    hmax_for_sph = 0;
    if (isleaf){
	bhparticle * bp = bpfirst;
	for(i = 0; i < nparticle; i++){
	    real hp = bp->get_rp()->get_h();
	    if(hmax_for_sph < hp) hmax_for_sph = hp;
	    bp=bp->get_bhp_next();
	}
    }else{
	for(i=0;i<8;i++){
	    if (child[i] != NULL){
		child[i]->set_hmax_for_sph();
		if (hmax_for_sph < child[i]->hmax_for_sph)
		    hmax_for_sph = child[i]->hmax_for_sph; 
	    }
	}
    }
}
#endif



void  bhnode::set_cm_quantities()
{
    int i;
    cmpos = 0.0;
    cmmass = 0.0;
    if (nparticle == 0) return;
    if (isleaf){
	bhparticle * bp = bpfirst;
	for(i = 0; i < nparticle; i++){
	    real mchild = bp->get_rp()->get_mass();
	    cmpos += mchild*bp->get_rp()->get_pos();
	    cmmass += mchild;
	    bp=bp->get_bhp_next();
	}
    }else{
	for(i=0;i<8;i++){
	    if (child[i] != NULL){
		child[i]->set_cm_quantities();
		real mchild = child[i]->cmmass;
		cmpos += mchild*child[i]->cmpos;
		cmmass += mchild;
	    }
	}
    }
    cmpos /= cmmass;
}

inline real separation_squared(bhnode * p1,bhnode * p2)
{
    real r2 = 0;
    real xmin = (p1->get_length()+ p2->get_length())*0.5;
    vector dx = p1->get_pos() - p2->get_pos();
    for (int k = 0; k<ndim; k++){
	real adx = fabs(dx[k]);
	if (adx > xmin){
	    adx -= xmin;
	}else{
	    adx = 0;
	}
	r2 += adx*adx;
    }
    return r2;
}

inline real separation_squared0(bhnode * p1, vector & pos2)
{
    real r2 = 0;
    real xmin = p1->get_length()*0.5;
#if 0
    vector dx = p1->get_pos() - pos2;
    for (int k = 0; k<ndim; k++){
	real adx = fabs(dx[k]);
	if (adx > xmin){
	    adx -= xmin;
	    r2 += adx*adx;
	}
    }
#else
    real adx, ady, adz;
    vector * p = p1->get_posp();
    adx = fabs((*p)[0]-pos2[0]);
    ady = fabs((*p)[1]-pos2[1]);
    adz = fabs((*p)[2]-pos2[2]);
    if (adx>xmin){
	adx -= xmin;
	r2 += adx*adx;
    }
    if (ady>xmin){
	ady -= xmin;
	r2 += ady*ady;
    }
    if (adz>xmin){
	adz -= xmin;
	r2 += adz*adz;
    }
#endif	       
    
    return r2;
}

inline real separation_squared(bhnode * p1, vector & pos2)
{
    real r2 = 0;
    real xmin = p1->get_length()*0.5;
    real adx, ady, adz;
    vector * p = p1->get_posp();
    adx = fabs((*p)[0]-pos2[0])-xmin;
    ady = fabs((*p)[1]-pos2[1])-xmin;
    adz = fabs((*p)[2]-pos2[2])-xmin;
    if (adx>0.0){
	r2 += adx*adx;
    }
    if (ady>0.0){
	r2 += ady*ady;
    }
    if (adz>0.0){
	r2 += adz*adz;
    }
    
    return r2;
}

inline int  are_overlapped(bhnode * p1,bhnode * p2)
{
    real xmin = (p1->get_length()+ p2->get_length())*0.4999999999999999;
    vector dx = p1->get_pos() - p2->get_pos();
#if 0
    for (int k = 0; k<ndim; k++){
	if(fabs(dx[k]) > xmin) return 0;
    }
#else
    if((fabs(dx[0]) > xmin) ||(fabs(dx[1]) > xmin) ||(fabs(dx[2]) > xmin)) {
	return 0;
    }
	
#endif
    return 1;
}

inline real separation_squared(vector xcen, vector size, vector & pos2)
{
    real r2 = 0;
    real adx, ady, adz;
    adx = fabs(xcen[0]-pos2[0])-size[0];
    ady = fabs(xcen[1]-pos2[1])-size[1];
    adz = fabs(xcen[2]-pos2[2])-size[2];
    if (adx>0.0){
	r2 += adx*adx;
    }
    if (ady>0.0){
	r2 += ady*ady;
    }
    if (adz>0.0){
	r2 += adz*adz;
    }
    return r2;
}

inline int  are_overlapped(vector xcen, vector size,bhnode * p2)
{
    real len2 = p2->get_length()*0.4999999999999;  
    vector dx = xcen - p2->get_pos();
    for(int k=0;k<3;k++){
	if(fabs(dx[k]) > size[k]+len2)return 0;
    }
    //    if(MP_myprocid()==1){
    //	cerr << "Overlap " ; PRC(p2->get_pos()); PRL(len2);
    //    }
    return 1;
}


#ifdef SPH
int check_and_set_nbl(bhnode * p1,bhnode * p2);
int check_and_set_nbl(bhnode * p1,bhnode * p2)
{
    int iret = 0;
    if(p1 == NULL) return iret;
    if(p2 == NULL) return iret;
    real rcrit = p1->hmax_for_sph;
    if (rcrit <  p2->hmax_for_sph)rcrit = p2->hmax_for_sph;
    rcrit *= 2;
    real rcrit2 = rcrit*rcrit;
    if(separation_squared(p1,p2) > rcrit2) return iret;
    if (p1->isleaf == 0 || p2->isleaf == 0){
	//
	// either node is not leaf. Go down
	//
	if (p1->isleaf || (p2->isleaf == 0) && p2->l > p1->l){
	    //
	    // p1 is already leaf, or both are node but p2 is larger.
	    // go down p2 by 
	    for(int i = 0; i<8;i++)
		iret |= check_and_set_nbl(p1, p2->child[i]);
	}else{
	    //
	    // now, we can go down p1 ...
	    for(int i = 0; i<8;i++)
		iret |= check_and_set_nbl(p1->child[i], p2);
	}
    }else{
	//
	// both are leaves; can directly evaluate particles
	bhparticle * bpi = p1->bpfirst;
	bhparticle * bpj = p2->bpfirst;
	for(int i = 0; i < p1->nparticle; i++)
	    for(int j = 0; j < p2->nparticle; j++){
		if((bpi+i)->get_key() <(bpj+j)->get_key() ){
		    //
		    // here, comparison of key guarantee that a pair
		    // is evaluated only once
	  
		    iret |=check_and_set_nbl(*((bpi+i)->get_rp()),
					     *((bpj+j)->get_rp()));
		}
	    }
    }
    return iret;
}

#endif
static bhparticle * bp = NULL;
static int bhpsize = 0;
static int bnsize = 0;
static bhnode * bn;
static int bnused;

bhnode * get_bhroot()
{
    return bn;
}
void set_cm_quantities_for_default_tree()
{
    bn->set_cm_quantities();
}

inline int octant_index_2(vector nodepos, vector ppos)
{
    register int i=0;
    if(nodepos[0]<ppos[0])i+=4;
    if(nodepos[1]<ppos[1])i+=2;
    if(nodepos[2]<ppos[2])i++;
    return i;
}
inline int octant_index(vector nodepos, vector ppos)
{
    register int i0,i1,i2;
    i0= (nodepos[0]<ppos[0])? 4:0;
    i1= (nodepos[1]<ppos[1])? 2:0;
    i2= (nodepos[2]<ppos[2])? 1:0;
    return i0+i1+i2;
}

void bhnode::allocate_childrens_and_assign_particles(bhnode * &heap_top,
						int & heap_remainder,
						int n_critical)
{
    //    cerr << "Allocate_childrens... called\n"; 
    bhparticle * bhparray[BPWORKMAX];
    int nbhp = 0;
    for (bhparticle * p = bpfirst ; p != NULL; p = p->get_bhp_next()){
	bhparray[nbhp] = p;
	nbhp++;
	if(nbhp >= BPWORKMAX){
	    cerr << "BPWORKMAX Too Small. Please make it larger " << BPWORKMAX <<endl;
	    exit(1);
	}
    }
    for (int i = 0;i<nbhp;i++){
	bhparticle * p = bhparray[i];
	int index = octant_index(pos,p->get_rp()->get_pos());
	if(child[index] == NULL){
	    vector new_pos = pos + vector( ((index&4)*0.5-1)*l/4,
				       ((index&2)    -1)*l/4,
					   ((index&1)*2  -1)*l/4);
	    child[index] = heap_top;
	    heap_top ++;
	    heap_remainder -- ;
	    child[index]->bpfirst = NULL;
	    child[index]->pos = new_pos;
	    child[index]->l = l*0.5;
	    child[index]->nparticle = 0;
	    child[index]->isleaf = 1;
	    for(int ii = 0;ii<8;ii++)child[index]->child[ii] = NULL;
	}
	p->set_bhp_next(child[index]->bpfirst);
	child[index]->bpfirst = p;
	child[index]->nparticle++;
    }
    for(int i = 0;i <8;i++){
	if((child[i] != NULL) && (child[i]->nparticle >= n_critical)){
	    child[i]->allocate_childrens_and_assign_particles(heap_top,
								  heap_remainder,
								  n_critical);
	}
    }
    isleaf = 0;
}


static vector childoffset[8];

void initialize_childoffset()
{
    real l = 1;
    for (int index = 0; index < 8; index++){
	childoffset[index] =   vector( ((index&4)*0.5-1)*l/4,
					((index&2)    -1)*l/4,
					((index&1)*2  -1)*l/4);
    }
}

    
#if 0
// recursive version. around 5% slowwer than iterative version
void bhnode::insert_particle(bhparticle * particle,
			     vector * bhpos,
			     bhnode * & heap_top,
			     int & heap_remainder,
			     int n_critical)
{
    // insert_particle
    // insert a particle to the tree
    //    if (MP_myprocid()==0){
    //PRL(particle->get_rp()->get_pos());
    //  PRC(l); PRC(nparticle); PRC(n_critical); PRL(pos);
    //  PRL(nparticle);
    //}
    if (nparticle < n_critical){
	// the node still has particles less than max
	// just insert the particle at the top of the list
	particle->set_bhp_next(bpfirst);
	bpfirst = particle;
    }else{
	// the node now have too many particles
	// Hmm, two possibilities
	// a) It was a leaf --- need allocate new children
	//                      and attach particles to them
	// b) It was not a leaf --- just assign it
	if (isleaf){
	    particle->set_bhp_next(bpfirst);
	    bpfirst = particle;
	    allocate_childrens_and_assign_particles(heap_top,heap_remainder, n_critical);
	}else{
	    int index = octant_index(pos,*bhpos);
	    if (child[index] == NULL){
		//		vector new_pos = pos + vector( ((index&4)*0.5-1)*l/4,
		//		       ((index&2)    -1)*l/4,
		//		       ((index&1)*2  -1)*l/4);
		vector new_pos = pos + childoffset[index]*l;
		child[index] = heap_top;
		heap_top->bpfirst = NULL;
		heap_top->pos = new_pos;
		heap_top->l = l*0.5;
		heap_top->nparticle = 0;
		heap_top->isleaf = 1;
		for(int ii = 0;ii<8;ii++)heap_top->child[ii] = NULL;
		heap_top ++;
		heap_remainder -- ;
		if (heap_remainder == 0){
		    cerr << "Myid = " << MP_myprocid() << "heap used up\n" ;
		    exit(1);
		}
	    }
	    child[index]->insert_particle(particle,bhpos,heap_top,heap_remainder, n_critical);
	}
    }
    nparticle++;
}
#else
// iterative version;
void bhnode::insert_particle(bhparticle * particle,
			     vector * bhpos,
			     bhnode * & heap_top,
			     int & heap_remainder,
			     int n_critical)
{
    // insert_particle
    // insert a particle to the tree
    //    if (MP_myprocid()==0){
    //PRL(particle->get_rp()->get_pos());
    //  PRC(l); PRC(nparticle); PRC(n_critical); PRL(pos);
    //  PRL(nparticle);
    //}
    bhnode * current = this;
    for(;;){
	if (current->nparticle < n_critical){
	    // the node still has particles less than max
	    // just insert the particle at the top of the list
	    particle->set_bhp_next(current->bpfirst);
	    current->bpfirst = particle;
	    current->nparticle++;
	    return;
	}else{
	    // the node now have too many particles
	    // Hmm, two possibilities
	    // a) It was a leaf --- need allocate new children
	    //                      and attach particles to them
	    // b) It was not a leaf --- just assign it
	    if (current->isleaf){
		particle->set_bhp_next(current->bpfirst);
		current->bpfirst = particle;
		current->allocate_childrens_and_assign_particles(heap_top,heap_remainder, n_critical);
		current->nparticle++;
		return;
	    }else{
		int index = octant_index(current->pos,*bhpos);
		if (current->child[index] == NULL){
		    double ll = current->l;
		    vector new_pos =current->pos + ll*childoffset[index];
		    current->child[index] = heap_top;
		    heap_top->bpfirst = NULL;
		    heap_top->pos = new_pos;
		    heap_top->l = ll*0.5;
		    heap_top->nparticle = 0;
		    heap_top->isleaf = 1;
		    for(int ii = 0;ii<8;ii++)heap_top->child[ii] = NULL;
		    heap_top ++;
		    heap_remainder -- ;
		    if (heap_remainder == 0){
			cerr << "Myid = " << MP_myprocid() << "heap used up\n" ;
			exit(1);
		    }
		}
		current->nparticle++;
		current=current->child[index];
	    }
	}
    }
}
#endif
		


void real_system::add_particles_to_tree(int nadd)
{
    bhnode * btmp = bn+bnused;
    int heap_remainder = bnsize-bnused;
    for(int i = n;i<n+nadd;i++){
	(bp+i)->set_rp(pb+i);
	(bp+i)->set_bhp_next(NULL);
	vector bhpos = (bp+i)->get_rp()->get_pos();
	bn->insert_particle(bp+i,&bhpos,btmp, heap_remainder, NCRIT_FOR_TREE);
    }
    bnused = bnsize - heap_remainder; 
    PRCI(bnsize);    PRL(heap_remainder);
    //    PRL(bn->sanity_check());
}

	


void real_system::setup_tree()
{
    if(MP_myprocid()==0)  cerr << "Setup tree: called\n";
    real rsize = initialize_bhp(n,get_particle_pointer(),bhpsize,bp);
    if (MP_proccount() > 1){
	real rmax = -xlowp[0][0];
	while(rsize < rmax) rsize*= 2;
    }
    
    int expected_bnsize =  (int)(bhpsize*0.6+100);
    if (bnsize < expected_bnsize){
	if (bnsize != 0){
	    delete [] bn;
	}
	bnsize = expected_bnsize;
	bn = new bhnode[bnsize];
	initialize_childoffset();
    }
    for(int j = 0; j<bnsize;j++) (bn+j)->clear();
    bn->assign_root(vector(0.0), rsize*2, NULL, 0);
    bhnode * btmp = bn+1;
    int heap_remainder = bnsize-1;
    for(int i = 0;i<n;i++){
	vector bhpos = (bp+i)->get_rp()->get_pos();
	bn->insert_particle(bp+i,&bhpos,btmp, heap_remainder, NCRIT_FOR_TREE);
    }
    bnused = bnsize - heap_remainder; 
    if(MP_myprocid()==0) {
	PR(bnsize);    PRL(heap_remainder);
    }
    //PRL(bn->sanity_check());
}

	
#ifdef SPH	
int sph_system::set_nnb_using_tree()
{
    setup_tree();
    real_particle * psph = get_particle_pointer();
    apply_vf(real_particle::clear_nnb);
    bn->set_hmax_for_sph();
    int iret = check_and_set_nbl(bn, bn);
    apply_vf(real_particle::sort_nblist);
    return iret;
}
#endif

inline void accumulate_force_from_point(vector dx, real r2, real eps2, 
				 vector & acc,
				 real & phi,
				 real jmass)
{
    double r2inv = 1/(r2+eps2);
    double rinv  = sqrt(r2inv);
    double r3inv = r2inv*rinv;
    phi -= jmass*rinv;
    acc += jmass*r3inv*dx;
}

static real total_interactions;
static int tree_walks;
static int nisum;
void clear_tree_counters()
{
    total_interactions = 0;
    tree_walks = 0;
    nisum = 0;
}
void print_tree_counters()
{
    real totalintall = total_interactions;   MP_sum(totalintall);
    int niall = nisum; MP_int_sum(niall);
    int twall = tree_walks; MP_int_sum(twall);
    real avg = totalintall/niall;
    if(MP_myprocid() == 0){
	cout <<"tree_walks = " <<twall   <<" interactions " << totalintall << " ntaverage = " << avg << endl;
    }
    MP_print_treestats(total_interactions, tree_walks, nisum, cout);
}

void calculate_force_from_interaction_list(const vector & pos,
					   real eps2, 
					    vector & acc,
					    real & phi,
					    vector * poslist,
					    real * masslist,
					    int list_length)
{
    acc = 0.0;
    phi = 0.0;
    for(int i = 0; i<list_length; i++){
	vector dx = *(poslist+i)-pos;
	real r2 = dx*dx;
	accumulate_force_from_point(dx, r2, eps2, acc, phi,*(masslist+i));
    }
}



void bhnode::accumulate_force_from_tree(vector & ipos, real eps2, real theta2,
					vector & acc,
					real & phi)
{
    if (nparticle == 0) return;
    vector dx = cmpos - ipos;
    real r2 = dx*dx;
    if (r2*theta2 > l*l){
	// node and position is well separated;
	accumulate_force_from_point(dx, r2, eps2, acc, phi, cmmass);
	total_interactions += 1;
    }else{
	int i;
	if (isleaf){
	    bhparticle * bp = bpfirst;
	    for(i = 0; i < nparticle; i++){
		vector dx = bp->get_rp()->get_pos()-ipos;
		real pmass = bp->get_rp()->get_mass();
		    
		bp=bp->get_bhp_next();
		real r2 = dx*dx;
		accumulate_force_from_point(dx, r2, eps2, acc, phi,pmass);
		total_interactions += 1;
	    }
	}else{
	    for(i=0;i<8;i++){
		if (child[i] != NULL){
		child[i]->accumulate_force_from_tree(ipos,eps2,theta2, acc, phi);
		}
	    }
	}
    }
}

#if defined(GRAPE6)
extern "C"{
#include "grape6.h"
}
static int xxx;


inline void grape_send_jparticle(vector pos,
				 real mass,
				 int  address,
				 int index)
{
    int clusterid = 0;
    int one = 1;
    //    PRC(address); PRC(index); PRC(pos); PRL(mass);
#if 1
    g6_set_j_particle_multisend_mxfast_(&clusterid,&one,&address,&index,&mass,(double*)(&pos));
#else
    g6_set_j_particle_mxonly_(&clusterid,&address,&index,&mass,(double*)(&pos));
#endif    
    
}

#else
inline void grape_send_jparticle(vector pos,
				 real mass,
				 int  address,
				 int index)
{
    return;
}
#endif


void bhnode::add_to_interaction_list(bhnode & dest_node, real theta2,
				     vector * pos_list,
				     real * mass_list,
				     real_particle ** particle_list,
				     int & nlist,
				     int list_max,
				     int & first_leaf)
{
    if (nparticle == 0) return;
    if((separation_squared(&dest_node,cmpos)*theta2 > l*l)
       && (!are_overlapped(this,&dest_node) ) ){
	// node and position is well separated;
	*(pos_list+nlist) = cmpos;
	*(mass_list+nlist) = cmmass;
	nlist ++;
	if (nlist > list_max){
	    cerr << "List length exceeded\n";
	    exit(1);
	}
	
    }else{
	int i;
	if (isleaf || (this == (&dest_node))){
	    if (this == (&dest_node)){
		// adding the particles in the node itself
		first_leaf = nlist;
	    }
	    add_particles_to_interaction_list(dest_node, pos_list, mass_list,
					      particle_list, nlist, list_max);
	}else{
	    for(i=0;i<8;i++){
		if (child[i] != NULL){
		    child[i]->add_to_interaction_list(dest_node, theta2,
						      pos_list, mass_list,
						      particle_list,
						      nlist, list_max,
						      first_leaf);
		}
	    }
	}
    }
}

void bhnode::add_to_interaction_list_ponly(bhnode & dest_node, real theta2,
				     real_particle ** particle_list,
				     int & nlist,
				     int list_max,
				     int & first_leaf)
{
    if (nparticle == 0) return;
    if((separation_squared(&dest_node,cmpos)*theta2 > l*l)
       && (!are_overlapped(this,&dest_node) ) ){
	// node and position is well separated;
	grape_send_jparticle(cmpos, cmmass, nlist,nlist+LETINDEXBASE);

	nlist ++;
	if (nlist > list_max){
	    cerr << "List length exceeded\n";
	    exit(1);
	}
	
    }else{
	int i;
	if (isleaf || (this == (&dest_node))){
	    if (this == (&dest_node)){
		// adding the particles in the node itself
		first_leaf = nlist;
	    }
	    add_particles_to_interaction_list_ponly(dest_node, particle_list, nlist, list_max);
	}else{
	    for(i=0;i<8;i++){
		if (child[i] != NULL){
		    child[i]->add_to_interaction_list_ponly(dest_node, theta2,
						      particle_list,
						      nlist, list_max,
						      first_leaf);
		}
	    }
	}
    }
}


void bhnode::add_to_essential_tree(vector xcen,
				   vector size,
				   real theta2,
				   vector * pos_list,
				   real * mass_list,
				   int & nlist,
				   int list_max)
{
    if (nparticle == 0) return;
    //    if(MP_myprocid()==0){
    //	cerr << "add to LET "; PRC(nlist);PRC(cmpos); PRL(cmmass);
    //    }
	if(MP_myprocid()==999){
	    cerr << "add to "; PRC(nlist);PRC(cmpos); PRC(pos); PRC(l);PRC(xcen);PRL(size);
	    if(separation_squared(xcen,size,cmpos)*theta2 <= l*l) cerr <<"too close\n";
	    if(are_overlapped(xcen,size,this))cerr <<"overlapped\n";

	}
    
    if((separation_squared(xcen,size,cmpos)*theta2 > l*l)
       && (!are_overlapped(xcen,size,this) )){

	// node and box are well separated;
	if(MP_myprocid()==0){
	    cerr << "accepted "; PRC(l);PRC(cmpos); PRC(xcen);PRL(size);
	}
	*(pos_list+nlist) = cmpos;
	*(mass_list+nlist) = cmmass;
	nlist ++;
	if (nlist > list_max){
	    cerr << "List length exceeded\n";
	    exit(1);
	}
	
    }else{
	int i;
	if(MP_myprocid()==0){
	    cerr << "rejected "; PRC(l);PRC(cmpos); PRC(xcen);PRL(size);
	    if((separation_squared(xcen,size,cmpos)*theta2 < l*l))cerr <<"Too close\n";
       if (are_overlapped(xcen,size,this) )cerr <<"Overlap\n";
	}
	if (isleaf){
	    add_particles_to_essential_tree(pos_list, mass_list, nlist,
					    list_max);
	}else{
	    for(i=0;i<8;i++){
		if (child[i] != NULL){
		    child[i]->add_to_essential_tree(xcen,size, theta2,
						    pos_list, mass_list,
						    nlist, list_max);
		}
	    }
	}
    }
}

void bhnode::add_particles_to_interaction_list(bhnode & dest_node, 
					       vector * pos_list,
					       real * mass_list,
					       real_particle**  particle_list,
					       int & nlist,
					       int list_max)
{
    if (isleaf){
	bhparticle * bp = bpfirst;
	for(int i = 0; i < nparticle; i++){
	    real_particle * p =  bp->get_rp();
	    particle_list[nlist] = p;
	    pos_list[nlist] = p->get_pos();
	    mass_list[nlist] =p->get_mass();
	    nlist ++;
	    if (nlist > list_max){
		cerr << "List length exceeded\n";
		exit(1);
	    }
	    bp = bp->get_bhp_next();
	}
    }else{
	for(int i=0;i<8;i++){
	    if (child[i] != NULL){
		child[i]->add_particles_to_interaction_list(dest_node, pos_list,
							    mass_list, particle_list,
							    nlist, list_max);
		
	    }
	}
    }
}
void bhnode::add_particles_to_interaction_list_ponly(bhnode & dest_node, 
					       real_particle**  particle_list,
					       int & nlist,
					       int list_max)
{
    if (isleaf){
	bhparticle * bp = bpfirst;
	for(int i = 0; i < nparticle; i++){
	    real_particle * p =  bp->get_rp();
	    particle_list[nlist] = p;
	    grape_send_jparticle(p->get_pos(), p->get_mass(), nlist, p->get_index());
	    nlist ++;
	    if (nlist > list_max){
		cerr << "List length exceeded\n";
		exit(1);
	    }
	    bp = bp->get_bhp_next();
	}
    }else{
	for(int i=0;i<8;i++){
	    if (child[i] != NULL){
		child[i]->add_particles_to_interaction_list_ponly(dest_node, particle_list,
							    nlist, list_max);
		
	    }
	}
    }
}
void bhnode::add_particles_to_essential_tree(vector * pos_list,
					     real * mass_list,
					     int & nlist,
					     int list_max)
{
    if (isleaf){
	bhparticle * bp = bpfirst;
	for(int i = 0; i < nparticle; i++){
	    real_particle * p =  bp->get_rp();
	    if(MP_myprocid()==0){
		cerr << "add to LET "; PRC(nlist);PRC(p->get_pos()); PRL(p->get_mass());
	    }
	    pos_list[nlist] = p->get_pos();
	    mass_list[nlist] =p->get_mass();
	    
	    nlist ++;
	    if (nlist > list_max){
		cerr << "List length exceeded\n";
		exit(1);
	    }
	    bp = bp->get_bhp_next();
	}
    }else{
	cerr << "add_particles_to_essential_tree intenal error: non-leaf\n";
	exit(1);
    }
}





#ifdef HARP3

extern "C" void h3open_();
extern "C" void h3close_();
extern "C" void accel_by_harp3_separate_noopen_(int * ni, vector * xi,
						int * nj, vector * xj,
						real *m,
						vector *  a,
						real *p,
						real * eps2);

void calculate_force_from_interaction_list_using_grape(vector * pos_list, real * mass_list,
							int list_length, int first_leaf, int ni,
							real eps2,
							vector * acc_list, real * phi_list)
{
    static call_count = 0;
    static h3_open_state = 0;
    if (h3_open_state == 0){
	h3open_();
	h3_open_state = 1;
    }
    //    PR(ni);PRL(list_length);
    nisum += ni;
    tree_walks += 1;
    total_interactions += ((real)ni)*list_length;
    accel_by_harp3_separate_noopen_(&ni,pos_list+first_leaf, &list_length,pos_list, mass_list,
				    acc_list, phi_list, &eps2);
    call_count += ni;
    if (call_count > 500000){
	cerr << "Close and release GRAPE-4\n";
	h3close_();
	h3_open_state = 0;
	call_count = 0;
    }
}
#endif
#ifdef GRAPE5
#include <gp5util.h>

void my_g5_accel(int *ni, double (*xi)[3],   /* ip */
		 int *nj, double (*xj)[3], double *mj, /* jp */
		 double (*a)[3], double *p,  /* val to be returned */
		 double *eps)               /* scalar */
{
    int iout = 0;
    int offs, offr, nii, c, c0;
    int i, ic, np, nc;

    if (JMEMSIZE < *nj) {
	cerr << "nj " << *nj << "exceeded GRAPE-5 JMEMSIZE(" << JMEMSIZE << ")" << endl;
	exit(1);
    }

    g5_set_mj(0, *nj, mj);
    g5_set_xj(0, *nj, xj);
    g5_set_n(*nj);
    g5_set_eps_to_all(*eps);
    np = g5_get_number_of_pipelines_per_board();
    nc = g5_get_number_of_boards();
    c0 = g5_get_firstcluster();

    offs = 0;
    for (c = c0; c < nc+c0 && offs < *ni; c++) {
	nii = np;
	if (offs+nii > *ni){
	    nii = *ni - offs;
	}
	g5_set_xiMC(c, nii, (double (*)[3])xi[offs]);
	g5_runMC(c);
	offs += nii;
    }
    
    for (offr = 0; offr < *ni;) {
	for (c = c0; c < nc+c0; c++){
	    if (offr < *ni) {
		nii = np;
		if (offr+nii > *ni){
		    nii = *ni - offr;
		}
		g5_get_forceMC(c, nii, (double (*)[3])a[offr], &p[offr]);
		offr += nii;
	    }
	    if (offs < *ni) {
		nii = np;
		if (offs+nii > *ni){
		    nii = *ni - offs;
		}
		g5_set_xiMC(c, nii, (double (*)[3])xi[offs]);
		g5_runMC(c);
		offs += nii;
	    }
	}
    }
    for (i = 0; i < *ni; i++){
	p[i] *= -1;
    }
}

static double current_xmin = -1000;
static double current_xmax = 1000;
static double current_mmin =1.0/1024/1024;

void calculate_force_from_interaction_list_using_grape(vector * pos_list, real * mass_list,
							int list_length, int first_leaf, int ni,
							real eps2,
							vector * acc_list, real * phi_list)
{
    static int call_count = 0;
    static int h3_open_state = 0;
    if (h3_open_state == 0){
	g5_open();
	g5_set_range(current_xmin, current_xmax, current_mmin);
	h3_open_state = 1;
    }
    //    PR(ni);PRL(list_length);
    nisum += ni;
    tree_walks += 1;
    total_interactions += ((real)ni)*list_length;
    
    double eps = sqrt(eps2);
    my_g5_accel(&ni,(double (*)[3])(pos_list+first_leaf),
		     &list_length, (double (*)[3])pos_list, mass_list,
		     (double (*)[3])acc_list, phi_list, &eps);
    call_count += ni;
    if (call_count > 5000000){
	cerr << "Close and release GRAPE-4\n";
	g5_close();
	h3_open_state = 0;
	call_count = 0;
    }
}
#endif

#ifdef GRAPE6
#define cvector (real(*)[3])

void calculate_force_from_interaction_list_using_grape(vector * pos_list, real * mass_list,
							int list_length, int first_leaf, int ni,
							real eps2,vector * acc_list, real * phi_list)
{
    static int call_count = 0;
    static int g6_open_state = 0;
    int clusterid = 0;
    if (g6_open_state == 0){
	g6_open(clusterid);
	g6_open_state = 1;
    }

    g6_set_xunit(50);
    g6_set_tunit(50);

    nisum += ni;
    tree_walks += 1;
    total_interactions += ((real)ni)*list_length;

    real ti = 0;
    vector vtmp = vector(0.0);
    vector ajtmp = vector(0.0);
    vector jjtmp = vector(0.0);
    vector j2jtmp = vector(0.0);
    double tj, dtj;
    int ii, iend;
#define     MAXPIPELINESPERCHIP 96
    int index[MAXPIPELINESPERCHIP+1];
    double h2[MAXPIPELINESPERCHIP+1];
    vector v[MAXPIPELINESPERCHIP+1];
    vector jwork[MAXPIPELINESPERCHIP+1];
    int nharderror = 0;
    int ipmax = g6_npipes();
    int i;
    ti = 0.0;tj =ti; dtj = 0.0078125;
    g6_set_ti(clusterid, ti);
    for(i=0;i<list_length;i++){
	//g6_set_j_particle(clusterid,i,i,tj,dtj,mass_list[i],
	//	  (double*)(&j2jtmp),(double*)(&jjtmp),(double*)(&ajtmp),
	//	  (double*)(&vtmp),(double*)(pos_list+i));
	int one = 1;
#if 1	
	g6_set_j_particle_multisend_mxfast_(&clusterid,&one,&i,&i,mass_list+i,
						    (double*)(pos_list+i));
#else
	g6_set_j_particle_mxonly_(&clusterid,&i,&i,mass_list+i,
						    (double*)(pos_list+i));
#endif	
	for(int i = 0;i<2500;i++){xxx++;}
    }
    for(i=0;i<ipmax;i++){
	h2[i] = 0;
	v[i]=jjtmp;
	jwork[i] = 1e3;
    }
    int ierror;
    do{
	ierror = 0;
	for(i=0;i<ni;i+=ipmax){
	    int error;
	    int ii;
	    iend = ipmax; if  (iend+i > ni) iend = ni-i;
	    for(ii=0;ii<iend;ii++){
		index[ii]=first_leaf+i+ii;
		acc_list[i+ii] = 10;
		phi_list[i+ii] = 10;
	    }
	    ii = first_leaf+i;
	    g6calc_firsthalf_(&clusterid, &list_length, &iend,index,
			     (cvector pos_list)+ii, (cvector (&v)), (cvector acc_list)+i,
			     (cvector (&jwork)),phi_list+i,&eps2,h2);
	    if (error = g6calc_lasthalf_(&clusterid, &list_length, &iend,index,
					(cvector pos_list)+ii, (cvector v), &eps2,(double*)h2,
					(cvector acc_list)+i,(cvector jwork),(double*)(phi_list+i))){
		nharderror ++;
		if (nharderror > 10){
		    cerr << "Id = " << MP_myprocid() << " Too many hard error " <<endl;
		    exit(1);
		}
		g6_reinitialize(clusterid);
		ierror = 1;
		i = ni;
	    }
	}
    }while(ierror);
}
void calculate_force_from_interaction_list_using_grape(real_particle ** particle_list,
							int list_length, int first_leaf, int ni,
							real eps2)
{
    nisum += ni;
    tree_walks += 1;
    total_interactions += ((real)ni)*list_length;

    real ti = 0;
    vector jjtmp = vector(0.0);
    double tj, dtj;
    int ii, iend;
#define     MAXPIPELINESPERCHIP 96
    int index[MAXPIPELINESPERCHIP+1];
    double h2[MAXPIPELINESPERCHIP+1];
    vector x[MAXPIPELINESPERCHIP+1];
    vector v[MAXPIPELINESPERCHIP+1];
    vector jwork[MAXPIPELINESPERCHIP+1];
    vector alist[MAXPIPELINESPERCHIP+1];
    vector jlist[MAXPIPELINESPERCHIP+1];
    real plist[MAXPIPELINESPERCHIP+1];
    int nharderror = 0;
    int ipmax = g6_npipes();
    int i;
    int clusterid = 0;
    g6_flush_jp_buffer_and_multisend(clusterid,1);

    ti = 0.0;    g6_set_ti(clusterid, ti);
    for(i=0;i<ipmax;i++){
	h2[i] = 0;
	v[i]=jjtmp;
	jwork[i] = 1e3;
    }
    int ierror;
    do{
	ierror = 0;
	for(i=0;i<ni;i+=ipmax){
	    int error;
	    int ii;
	    iend = ipmax; if  (iend+i > ni) iend = ni-i;
	    real_particle ** pp = particle_list+first_leaf+i; 
	    for(ii=0;ii<iend;ii++){
		index[ii]=(*pp)->get_index();
		x[ii] = (*pp)->get_pos();
		alist[ii] = 10;
		plist[ii] = 10;
		pp++;
		//		PRC(index[ii]); PRL(x[ii]);
	    }
	    g6calc_firsthalf_(&clusterid, &list_length, &iend,index,
			     (cvector x), (cvector v), (cvector alist),
			     (cvector jwork),plist,&eps2,h2);
	    if (error = g6calc_lasthalf_(&clusterid, &list_length, &iend,index,
					(cvector x), (cvector v), &eps2,(double*)h2,
					(cvector alist),(cvector jwork),(double*)(plist))){
		nharderror ++;
		g6_print_chip_status(clusterid);
		if (nharderror > 10){
		    cerr << "Id = " << MP_myprocid() << " Too many hard error " <<endl;
		    exit(1);
		}
		g6_reinitialize(clusterid);
		ierror = 1;
		i = ni;
	    }else{
		real_particle ** pp = particle_list+first_leaf+i; 
		for(ii=0;ii<iend;ii++){
		    //		    PRC(index[ii]); PRC(alist[ii]);PRL(plist[ii]);
		    (*pp)->set_acc_gravity(alist[ii]);
		    (*pp)->set_phi_gravity(plist[ii]);
		    pp++;
		}
	    }
	}
    }while(ierror);
}
#endif

const int list_max = BHLISTMAX;
static real mass_list[list_max];
static vector pos_list[list_max];
static real_particle* particle_list[list_max];

void bhnode::create_essential_tree(vector xcen,
				   vector size,
				   real theta2,
				   vector * &plist,
				   real * &mlist,
				   int & nlist)
{
    nlist = 0;
    if (MP_myprocid() == 999)cerr << " create_LET " << xcen << " " << size <<endl;

    add_to_essential_tree(xcen,size, theta2,
			  pos_list, mass_list,
			  nlist, list_max);
    if (MP_myprocid() == 999)cerr << " create_LET " << nlist <<endl;
    plist = pos_list;
    mlist = mass_list;
}

void pack_real_particles(int & ni,
		    vector * pos_list,
		    real *mass_list,
		    real_particle ** particle_list)
{
    int ninew = 0;
    if (MP_myprocid()==999){
	cerr << "pack_particles original indices" <<endl;
	for(int i = 0; i<ni;i++) cerr << i << " "
				      << particle_list[i]->get_index()<<endl;
    }
	    
	    
    for(int i = 0; i<ni;i++){
	if (particle_list[i]->get_index() < LETINDEXBASE){
	    if(i > ninew){
		// swap location i and ninew
		real_particle * tmp = particle_list[i];
		particle_list[i] = particle_list[ninew];
		particle_list[ninew] = tmp;
	    }
	    ninew++;
	}
    }
    if (MP_myprocid()==999)
	if(ninew < ni){
	    cerr << "pack_particles new  indices" <<endl;
	    for(int i = 0; i<ninew;i++)
		cerr << i << " " << particle_list[i]->get_index()<<endl;
	}
    if(ninew < ni){
	for(int i = 0; i<ni;i++){
	    pos_list[i] = particle_list[i]->get_pos();
	    mass_list[i] = particle_list[i]->get_mass();
	}
	ni = ninew;
    }
}

void pack_real_particles(int & ni,  real_particle ** particle_list)
{
    int ninew = 0;
    if (MP_myprocid()==999){
	cerr << "pack_particles original indices" <<endl;
	for(int i = 0; i<ni;i++) cerr << i << " "
				      << particle_list[i]->get_index()<<endl;
    }
	    
	    
    for(int i = 0; i<ni;i++){
	if (particle_list[i]->get_index() < LETINDEXBASE){
	    if(i > ninew){
		// swap location i and ninew
		real_particle * tmp = particle_list[i];
		particle_list[i] = particle_list[ninew];
		particle_list[ninew] = tmp;
	    }
	    ninew++;
	}
    }
    if (MP_myprocid()==999)
	if(ninew < ni){
	    cerr << "pack_particles new  indices" <<endl;
	    for(int i = 0; i<ninew;i++)
		cerr << i << " " << particle_list[i]->get_index()<<endl;
	}
    if(ninew < ni){
	ni = ninew;
    }
}


void bhnode::evaluate_gravity_using_tree_and_list(bhnode & source_node,
						  real theta2,
						  real eps2,
						  int ncrit)
{
    real epsinv = 1.0/sqrt(eps2);
#ifdef GRAPE
    static vector * acc_list = NULL;
    static real * phi_list = NULL;
    if (acc_list == NULL){
	acc_list = new vector[ncrit + 100];
	phi_list = new real[ncrit + 100];
    }
#endif
    //    PR(pos); PR(nparticle); PRL(isleaf);
    if((nparticle > ncrit) && (isleaf==0)){
	for(int i=0;i<8;i++){
	    if (child[i] != NULL){
		child[i]->evaluate_gravity_using_tree_and_list(source_node,
							       theta2,
							       eps2,
							       ncrit);
	    }
	}
    }else{
	//
	// node is below critical ... first create list
	//
	if (nparticle > 0){
	    int list_length = 0;
	    int first_leaf = -1;
	    source_node.add_to_interaction_list(*this,  theta2,
						pos_list,
						mass_list,
						particle_list,
						list_length,
						list_max,
						first_leaf);
	    if (first_leaf == -1){
		cerr << "evaluate_gravity: impossible error \n";
		cerr << "failed to find the node in the tree \n";
		exit(1);
	    }
	    int ni = nparticle;
	    pack_real_particles(ni, pos_list+first_leaf,mass_list+first_leaf,
				particle_list+first_leaf);
#if !defined(GRAPE)
	    for(int i = 0; i < ni; i++){
		real_particle * p = particle_list[i+first_leaf];
		vector acc;
		real phi;
		calculate_force_from_interaction_list(pos_list[i+first_leaf],eps2, acc, phi,
						      pos_list,mass_list,list_length);
		p->set_acc_gravity(acc);
		p->set_phi_gravity(phi + p->get_mass()*epsinv);
	    }
#elif defined(HARP3)
	    calculate_force_from_interaction_list_using_grape(pos_list, mass_list,list_length, first_leaf,
							       ni, eps2, acc_list, phi_list);
	    for(int i = 0; i < nparticle; i++){
		real_particle * p = particle_list[i+first_leaf];
		p->set_acc_gravity(acc_list[i]);
		p->set_phi_gravity(phi_list[i] + p->get_mass()*epsinv);
	    }
#elif defined(GRAPE5)
	    calculate_force_from_interaction_list_using_grape(pos_list, mass_list,list_length, first_leaf,
							       ni, eps2, acc_list, phi_list);
	    for(int i = 0; i < nparticle; i++){
		real_particle * p = particle_list[i+first_leaf];
		p->set_acc_gravity(acc_list[i]);
		p->set_phi_gravity(phi_list[i] + p->get_mass()*epsinv);
	    }
#elif defined(GRAPE6)
	    for(int i = 0; i < ni; i++){
		real_particle * p = particle_list[i+first_leaf];
		acc_list[i] = p->get_acc_gravity();
		phi_list[i] = p->get_phi_gravity();
	    }
	    calculate_force_from_interaction_list_using_grape(pos_list, mass_list,list_length, first_leaf,
							       ni, eps2, acc_list, phi_list);
	    for(int i = 0; i < ni; i++){
		real_particle * p = particle_list[i+first_leaf];
		//	    PRC(i);PRC(p->get_index());PRC(acc_list[i]);PRL(phi_list[i]);
		p->set_acc_gravity(acc_list[i]);
		p->set_phi_gravity(phi_list[i]);
	    }
	    
#endif
	}
    }
}
void bhnode::evaluate_gravity_using_tree_and_list_ponly(bhnode & source_node,
							real theta2,
							real eps2,
							int ncrit)
{
    real epsinv = 1.0/sqrt(eps2);
#ifdef GRAPE
    static vector * acc_list = NULL;
    static real * phi_list = NULL;
    if (acc_list == NULL){
	acc_list = new vector[ncrit + 100];
	phi_list = new real[ncrit + 100];
    }
#ifdef GRAPE6    
    static int call_count = 0;
    static int g6_open_state = 0;
    int clusterid = 0;
    if (g6_open_state == 0){
	g6_open(clusterid);
	g6_initialize_jp_buffer(clusterid,list_max);
	g6_open_state = 1;
    }

    g6_set_xunit(50);
    g6_set_tunit(50);
#endif
    
#endif
    //    PR(pos); PR(nparticle); PRL(isleaf);
    if((nparticle > ncrit) && (isleaf==0)){
	for(int i=0;i<8;i++){
	    if (child[i] != NULL){
#ifdef GRAPE6
		child[i]->evaluate_gravity_using_tree_and_list_ponly(source_node,
							       theta2,
							       eps2,
							       ncrit);
#else
		child[i]->evaluate_gravity_using_tree_and_list(source_node,
							       theta2,
							       eps2,
							       ncrit);
#endif
	    }
	    
	}
    }else{
	//
	// node is below critical ... first create list
	//
	if (nparticle > 0){
	    int list_length = 0;
	    int first_leaf = -1;
	    source_node.add_to_interaction_list_ponly(*this,  theta2,
						particle_list,
						list_length,
						list_max,
						first_leaf);
	    if (first_leaf == -1){
		cerr << "evaluate_gravity: impossible error \n";
		cerr << "failed to find the node in the tree \n";
		exit(1);
	    }
	    int ni = nparticle;
	    pack_real_particles(ni, particle_list+first_leaf);
#ifdef GRAPE6
	    calculate_force_from_interaction_list_using_grape(particle_list,list_length, first_leaf,
							       ni, eps2);
#endif	
	}
    }
}

void evaluate_gravity_using_default_tree_and_list(real theta2,
					  real eps2,
					  int ncrit)
{
    bn->evaluate_gravity_using_tree_and_list_ponly(*bn, theta2,eps2, ncrit);
}

void real_particle::calculate_gravity_using_tree(real eps2, real theta2)
{
    acc_gravity = 0;
    phi_gravity = mass/sqrt(eps2);
    bn->accumulate_force_from_tree(pos,eps2,theta2,
				  acc_gravity, phi_gravity);
    nisum += 1;
    //    PRC(index); PRC(acc_gravity); PRL(phi_gravity);
}


#ifdef TESTXXX
//
// do the serious test of
// construction of tree
// consistency of tree
// validity of the neighbour list (by comparing with the result
// of direct calculation

void main()
{
    static sph_system pb;
    int n;
    cerr << "Enter n:";
    cin >> n ;
    pb.create_uniform_sphere(n, 0 , 1);
    //    pb.dump();
    int nkey = 0;
    pb.initialize_h_and_nbl(pow(1.0/n,0.33333));
    static sph_system pbcopy = pb;
    copy_sph_particles(&pb, &pbcopy);
    real_particle * psph = pb.get_particle_pointer();
    real_particle * psphcopy = pbcopy.get_particle_pointer();
    pb.set_nnb_using_tree();
    cerr << "Dumping copy ... \n";
    cerr << "checking NB \n";
    int error = 0;
    for(int i = 0; i<n; i++){
	(psph+i)->sort_nblist();
	int err = 0;
	if((psph+i)->get_nnb() != (psphcopy+i)->get_nnb()){
	    cerr << "Neighbour count differs for "; PRL(i);
	    err = 1;
	    
	}
	if (err == 0){
	    for(int j = 0; (j< (psph+i)->get_nnb()) && (err == 0); j++){
		if ((psph+i)->get_neighbor(j)->get_index()!=
		    (psphcopy+i)->get_neighbor(j)->get_index()) err = 1;
	    }
	}
	if(err){
	    (psph+i)->dump();
	    (psphcopy+i)->dump();
	    error ++;
	}
    }
    PRL(error);
}
#endif

#ifdef TEST
//
// do the serious test of
// construction of tree
// consistency of tree
// validity of the neighbour list (by comparing with the result
// of direct calculation

void main()
{
    static sph_system pb;
    int n;
    cerr << "Enter n:";
    cin >> n ;
    pb.create_uniform_sphere(n, 0 , 1);
    //    pb.dump();
    int nkey = 0;
    bhparticle * bp = NULL;

    bn = new bhnode[n];
    for(int i = 0; i<1; i++){
	real rsize = initialize_key(n,pb.get_particle_pointer(),nkey,bp);
	for(int j = 0; j<n;j++) (bn+j)->clear();
	bn->assign_root(vector(0.0), rsize*2, bp, n);
	bhnode * btmp = bn+1;
	int heap_remainder = n-1;
	BHlong key = 0;
        bn->create_tree_recursive(btmp,  heap_remainder,key, default_key_length, 4);
    }
    PRL(bn->sanity_check());
    pb.initialize_h_and_nbl(pow(1.0/n,0.33333));
    bn->set_hmax_for_sph();
    //    bn->dump();
    bn->set_cm_quantities();
    //    bn->dump();
    static sph_system pbcopy = pb;
    copy_sph_particles(&pb, &pbcopy);
    real_particle * psph = pb.get_particle_pointer();
    real_particle * psphcopy = pbcopy.get_particle_pointer();
    for(int i = 0; i<n; i++){
	(psph+i)->clear_nnb();
    }
    PRL(check_and_set_nbl(bn, bn));
    cerr << "Dumping copy ... \n";
    cerr << "checking NB \n";
    int error = 0;
    for(int i = 0; i<n; i++){
	(psph+i)->sort_nblist();
	int err = 0;
	if((psph+i)->get_nnb() != (psphcopy+i)->get_nnb()){
	    cerr << "Neighbour count differs for "; PRL(i);
	    err = 1;
	    
	}
	if (err == 0){
	    for(int j = 0; (j< (psph+i)->get_nnb()) && (err == 0); j++){
		if ((psph+i)->get_neighbor(j)->get_index()!=
		    (psphcopy+i)->get_neighbor(j)->get_index()) err = 1;
	    }
	}
	if(err){
	    (psph+i)->dump();
	    (psphcopy+i)->dump();
	    error ++;
	}
    }
    PRL(error);
    pb.use_self_gravity = 1;
    pb.eps2_for_gravity = 0.01;
#define COMPARISON_WITH_DIRECT    
#ifdef COMPARISON_WITH_DIRECT    
    pb.calculate_uncorrected_gravity_direct();
    copy_sph_particles(&pb, &pbcopy);
    psphcopy = pbcopy.get_particle_pointer();
    cerr << "Direct force \n";
    for(int i = 0; i<n; i++){
	real phi = (psphcopy+i)->get_phi_gravity();
	vector acc  = (psphcopy+i)->get_acc_gravity();
	PR(i); PR(phi); PRL(acc);
    }
#endif


    
    cerr << "Tree   force \n";
    for(int j = 0; j<10; j++){
	PRL(j);
	pb.apply_vf(real_particle::clear_acc_phi_gravity);
	for(int i = 0; i<n; i++){
	    (psph+i)->calculate_gravity_using_tree(pb.eps2_for_gravity, 0.4);
	}
    }
    pb.apply_vf(real_particle::clear_acc_phi_gravity);
    bn->evaluate_gravity_using_tree_and_list(*bn,0.4,pb.eps2_for_gravity,1);
#ifdef COMPARISON_WITH_DIRECT    
    real perrmax = 0;
    real ferrmax = 0;
    for(int i = 0; i<n; i++){
	real phi = (psph+i)->get_phi_gravity();
	real phierr = (psphcopy+i)->get_phi_gravity()-phi;
	vector acc  = (psph+i)->get_acc_gravity();
	vector accerr  = (psphcopy+i)->get_acc_gravity()-acc;
	PR(i); PR(phi); PRC(acc); PRC(phierr); PRL(accerr);
	real prelerr = fabs(phierr/phi);
	real frelerr = abs(accerr)/abs(acc);
	if(perrmax < prelerr) perrmax = prelerr;
	if(ferrmax < frelerr) ferrmax = frelerr;
    }
    PR(perrmax);    PRL(ferrmax);
#else
    for(int i = 0; i<n; i++){
	real phi = (psph+i)->get_phi_gravity();
	vector acc  = (psph+i)->get_acc_gravity();
	PR(i); PR(phi); PRL(acc); 
    }
	
#endif    
    
}
#endif

	

#ifdef TESTXX
//
// Sample test for timing purpose...

void main()
{
    static sph_system pb;
    int n;
    cerr << "Enter n:";
    cin >> n ;
    pb.create_uniform_sphere(n, 0 , 1);
    //    pb.dump();
    int nkey = 0;
    bhparticle * bp = NULL;

    bn = new bhnode[n];
    for(int i = 0; i<10; i++){
	real rsize = initialize_key(n,pb.get_particle_pointer(),nkey,bp);
	for(int j = 0; j<n;j++) (bn+j)->clear();
	bn->assign_root(vector(0.0), rsize*2, bp, n);
	bhnode * btmp = bn+1;
	int heap_remainder = n-1;
	BHlong key = 0;
        bn->create_tree_recursive(btmp,
				  heap_remainder,key,
				  default_key_length, 8 );
	PRL(heap_remainder);
    }
    PRL(bn->sanity_check());
    real_particle * psph = pb.get_particle_pointer();
    real h0 = pow(1.0/n,0.33333);
    for(int i = 0; i<10; i++){
	
	pb.apply_vf(real_particle::set_h, h0);
	pb.apply_vf(real_particle::clear_nnb);
	bn->set_hmax_for_sph();
	//    bn->dump();
	PRL(check_and_set_nbl(bn, bn));
	pb.apply_vf(real_particle::sort_nblist);
		
    }
}
#endif
