#ifndef _NBODY_H
#define _NBODY_H

#define NMAXPROC (500)
#define NMAXSAMPLE (20000)
#define BHLISTMAX (80000)
#define LETINDEXBASE (1000000000)
#define NSIZEFACTOR 1.1
#define NSIZEBIAS  100000
#define FUZZ (1e-8)
#include "nbody_particle.h"

inline int arraysize(int n)
{
    return (int) (n*NSIZEFACTOR+NSIZEBIAS);
}

void wall_init();
void MP_initialize(int argc,char *argv[]);
void MP_end();
void MP_sync();
int MP_myprocid();
int MP_proccount();
void MP_copyparams(real &dt,
		   real &dtsnapout,
		   int &outlogstep,
		   real &tend,
		   real &eps,
		   real &theta,
		   int &ncrit,
		   real &pos_scale,
		   real &vel_scale);
void MP_convert_snap_name(int& flag, char * name);

void MP_gather_sample_coords(int&nsample, vector * sample_array);
void MP_int_bcast(int&i);
void MP_int_sum(int&i);
void MP_sum(double& r);
void MP_double_bcast(double*i, int nwords);
void MP_exchange_particle(int ibox,
			  nbody_particle * pb,
			  int firstloc,
			  int nparticles,
			  int isource,
			  int &iloc);
int MP_exchange_particle_with_overflow_check(int ibox,
					     nbody_particle * pb,
					     int firstloc,
					     int nparticles,
					     int isource,
					     int &iloc,
					     int &nsend);

int MP_intmax(int localval);
double MP_doublemax(double localval);
void MP_exchange_bhlist(int ibox,
			int nlist,
			int nbmax,
			vector * plist,
			real * mlist,
			int isource,
			int & nrecvlist,
			vector * precvbuf,
			real * mrecvbuf);

void MP_collect_cmterms(vector& pos,vector& vel,real& mass);

void MP_print_times(ostream &s);
void MP_print_treestats(real total_interactions,
			int tree_walks,
			int nisum,
			ostream &s);


// distribute.C

void initialize_division(int nbody);

void setup_division(nbody_particle * pb,
		    int nbody,
		    int npdim[3],
		    vector* xlow,
		    vector* xhigh);

void exchange_particles(nbody_particle * pb,
			int& nbody,
			int nbmax,
			vector * xlow,
			vector * xhigh);
int exchange_particles_with_overflow_check(nbody_particle * pb,
					   int& nbody,
					   int nbmax,
					   vector * xlow,
					   vector * xhigh);

void exchange_local_essential_trees(nbody_particle * pb,
				    int nbody,
				    int nbmax,
				    real theta2,
				    vector * xlow,
				    vector * xhigh,
				    bhnode * bp,
				    int & ntot);

// BHtree.h

bhnode * get_bhroot();

//time.C

real wall_time();
real cpu_time();

#endif





