#ifndef  BHTREE_H
#  define   BHTREE_H
/*-----------------------------------------------------------------------------
 *  BHtree : basic class for C++ implementation of BH treecode
 *  J. Makino 1998/12/14
 *  Modified for tree construction through insertion
 *-----------------------------------------------------------------------------
 */

// First include some particle class
// This need, someday, to be changed to template...
#include "vector.h"
#include "nbody_particle.h"
#define NBODY
#ifdef NBODY
typedef nbody_particle real_particle;
typedef nbody_system real_system;
#endif
#ifdef SPH
typedef sph_particle real_particle;
typedef sph_system real_system;
#endif

#define BPWORKMAX 50 

// The following dependence on ALPHA is introduced by
// Andreas.Adelmann@psi.ch
// Thank you Andreas!

#ifdef __alpha
   typedef  long BHlong;
#else
   typedef  long long BHlong;
#endif

class bhparticle
{
private:
    real_particle * rp;
    bhparticle * bhp_next;
public:
    bhparticle(){
	rp = NULL;
	bhp_next = NULL;
    }
    void set_bhp_next(bhparticle * p){bhp_next = p;}
    bhparticle * get_bhp_next(){return bhp_next ;}
    void set_rp(real_particle * p){rp = p;}
    real_particle * get_rp(){return rp ;}
};


class bhnode
{
private:
    vector pos;
    real l;
    bhnode * child[8];
    bhparticle * bpfirst;
    int nparticle;
    int isleaf;
#ifdef SPH    
    real hmax_for_sph;
#endif    
    vector cmpos;
    real cmmass;
    
public:
    bhnode(){
	pos = 0.0;
	l = 0.0;
	for(int i = 0; i<8;i++)child[i] = NULL;
	bpfirst = NULL;
	nparticle = 0;
	isleaf = 1;
#ifdef SPH	
	hmax_for_sph = 0;
#endif	
	cmpos = 0.0;
	cmmass = 0.0;
    }
    void clear(){
	pos = 0.0;
	l = 0.0;
	for(int i = 0; i<8;i++)child[i] = NULL;
	bpfirst = NULL;
	nparticle = 0;
	isleaf = 1;
#ifdef SPH	
	hmax_for_sph = 0;
#endif	
	cmpos = 0.0;
	cmmass = 0.0;
    }
    void set_pos(vector newpos){pos = newpos;}
    vector get_pos(){return pos;}
	vector*  get_posp()                         {return &pos;}
    void set_length(real newl){l = newl;}
    real get_length(){return l;}
    void allocate_childrens_and_assign_particles(bhnode * &heap_top,
						 int & heap_remainder,
						 int n_critical);
    void insert_particle(bhparticle * particle,
			 vector * bhpos,
			 bhnode * & heap_top,
			 int & heap_remainder,
			 int n_critical);
    void assign_root(vector root_pos, real length, bhparticle * bp, int nparticle);
    void dump(int indent = 0);
    int sanity_check();
#ifdef SPH    
    void set_hmax_for_sph();
    real get_hmax_for_sph(){return hmax_for_sph;}
#endif    
    int friend check_and_set_nbl(bhnode * p1,bhnode * p2);
    void set_cm_quantities();
    void accumulate_force_from_tree(vector & ipos, real eps2, real theta2,
				   vector & acc,
				   real & phi);
    void add_to_interaction_list(bhnode & dest_node, real theta2,
				 vector * pos_list,
				 real * mass_list,
				 real_particle ** particle_list,
				 int & nlist,
				 int list_max,
				 int & first_leaf);
    void add_particles_to_interaction_list(bhnode & dest_node, 
					       vector * pos_list,
					       real * mass_list,
					       real_particle ** particle_list,
					       int & nlist,
					       int list_max);
    
    void add_to_interaction_list_ponly(bhnode & dest_node, real theta2,
				 real_particle ** particle_list,
				 int & nlist,
				 int list_max,
				 int & first_leaf);
    void add_particles_to_interaction_list_ponly(bhnode & dest_node, 
					       real_particle ** particle_list,
					       int & nlist,
					       int list_max);
    
    void evaluate_gravity_using_tree_and_list(bhnode & source_node,
					      real theta2,
					      real eps2,
					      int ncrit);
    void evaluate_gravity_using_tree_and_list_ponly(bhnode & source_node, 
							real theta2,
							real eps2,
							int ncrit);
    void add_to_essential_tree(vector xcen,
			       vector size,
			       real theta2,
			       vector * pos_list,
			       real * mass_list,
			       int & nlist,
			       int list_max);
    void add_particles_to_essential_tree(vector * pos_list,
					 real * mass_list,
					 int & nlist,
					 int list_max);
    void create_essential_tree(vector xcen,
			       vector size,
			       real theta2,
			       vector * &plist,
			       real * &mlist,
			       int & nlist);
};


void clear_tree_counters();
void print_tree_counters();
#endif
