WEBDIR = /usr2/makino/WWW/softwares/pC++tree
PGPLOT_DIR = /usr/local/pgplot5.2
#PGPLOT_DIR = /data6/makino/PDS/pgplot_linux/pgplot
PGINCLUDE =  -I$(PGPLOT_DIR)
CFLAGS = $(FLOAT_OPTIONS) -DREAL=double -O4 
CCC = cxx
CPPFLAGS = -DNOGRAPHICS -DTREE $(PGINCLUDE)  $(FLOAT_OPTIONS) -O4  

#CFLAGS = $(FLOAT_OPTIONS) -DREAL=double -O4 -ffast-math -funroll-loops 
#CCC = g++
#CPPFLAGS = -DNOGRAPHICS -DTREE $(PGINCLUDE)  $(FLOAT_OPTIONS) -O4   -ffast-math -funroll-loops -p
#
# Add -DNOGRAPHICS for installation without PGPLOT
#CPPFLAGS =   -DTREE $(PGINCLUDE) -p $(FLOAT_OPTIONS) -O4   -ffast-math -funroll-loops
#PGLIB     =  -L$(PGPLOT_DIR) -g3 -O4 -lcpgplot -lpgplot -lX11 -lUfor -lfor -lFutil -lm -lprof1 -lpdf
PGLIB      =  -lm
#G4LIB =  -L/usr2/makino/src/pci-harp3/export/library -lg4a -lrt -lm
#G4LIB =  -L/usr6/kawai/pub/lib -lg4a -lrt -lm
G4LIB =  -L/usr2/makino/disk3src/harplibs -lg4a -lrt -lm
G6LIB =  -L../g6hib/ -lg6  -L../grape6 -lg6sim2  -lm
G6DIR = ../g6hib
H3LIB = -L/usr2/makino/src/harp3board -lharp3  -lrt -lm 

BASELIBOBJS = pgetopt.o distribute.o  second.o time.o 
LIBOBJS = $(BASELIBOBJS)  gravity.o nbody_MP.o BHtree.o
PLIBOBJS = $(BASELIBOBJS)  gravity.o  nbody_MP_MPI.o BHtree.o 
LIBOBJSG4 = pgetopt.o  gravity_g4.o BHtree_g4.o second.o
LIBOBJSG6 = $(BASELIBOBJS) gravity_g6.o BHtree_g6.o nbody_MP.o 
PLIBOBJSG6 = $(BASELIBOBJS) gravity_g6.o BHtree_g6.o   nbody_MP_MPI.o 

EXPORT_FILES = BHtree.h nbody_particle.h vector.h \
               BHtree.C	gravity.C nbody.C pgetopt.C \
	       second.c \
	       Makefile nbody_guide.tex\
               README COPYRIGHT \
               samplein sampleparm samplelog  samplelog_g4 

export: export.tar.gz
	ls -al export.tar.gz
export.tar.gz: $(EXPORT_FILES)
	tar cvf export.tar  $(EXPORT_FILES)
	gzip export.tar 
gravity.o : gravity.C  nbody_particle.h
	$(CCC)  $(CPPFLAGS)  -c gravity.C
gravity_g4.o : gravity.C  nbody_particle.h
	$(CCC)  -DHARP3 $(CPPFLAGS)  -c gravity.C
	mv gravity.o gravity_g4.o
gravity_g6.o : gravity.C  nbody_particle.h
	$(CCC)  -DGRAPE6 $(CPPFLAGS)  -c gravity.C
	mv gravity.o gravity_g6.o



nbody.o : nbody.C  nbody_particle.h
	$(CCC)  -c -DEVOLVE   $(CPPFLAGS)  nbody.C 
nbody : nbody.o   $(LIBOBJS)
	$(CCC)      $(CPPFLAGS) -o nbody nbody.o $(LIBOBJS) $(PGLIB)
nbody_MPI : nbody.o   $(PLIBOBJS)
	mpiCC    $(CPPFLAGS) -o nbody_MPI nbody.o $(PLIBOBJS) $(PGLIB)
nbody_g4 : nbody.C  nbody_particle.h $(LIBOBJSG4)
	$(CCC)  -DEVOLVE    $(CPPFLAGS) -o nbody_g4 nbody.C $(LIBOBJSG4) $(PGLIB) $(G4LIB)
nbody_g6_MPI : nbody.o   $(PLIBOBJSG6)
	mpiCC    $(CPPFLAGS) -o nbody_g6_MPI nbody.o $(PLIBOBJSG6) $(PGLIB) $(G6LIB)
nbody_g6 : nbody.C  nbody_particle.h $(LIBOBJSG6)
	$(CCC)  -DEVOLVE    $(CPPFLAGS) -o nbody_g6 nbody.C $(LIBOBJSG6) $(PGLIB) $(G6LIB)
nbody_h3 : nbody.C  nbody_particle.h $(LIBOBJSG4)
	$(CCC)  -DEVOLVE    $(CPPFLAGS) -o nbody_h3 nbody.C $(LIBOBJSG4) $(H3LIB)

BHtree.o : BHtree.C  nbody_particle.h BHtree.h 
	$(CCC)    $(CPPFLAGS) -c BHtree.C 
BHtree_g4.o : BHtree.C  nbody_particle.h BHtree.h 
	$(CCC) -DHARP3   $(CPPFLAGS) -c BHtree.C
	mv BHtree.o  BHtree_g4.o 
BHtree_g6.o : BHtree.C  nbody_particle.h BHtree.h 
	$(CCC) -I$(G6DIR) -DGRAPE6   $(CPPFLAGS) -c BHtree.C
	mv BHtree.o  BHtree_g6.o 
pgetopt.o : pgetopt.C  
	$(CCC)  $(CPPFLAGS)  -c pgetopt.C
nbody_MP.o : nbody_MP.C  
	$(CCC)  $(CPPFLAGS)  -c nbody_MP.C
nbody_MP_MPI.o : nbody_MP_MPI.C  
	mpiCC  $(CPPFLAGS)  -c nbody_MP_MPI.C
time.o : time.C  
	$(CCC)  $(CPPFLAGS)  -c time.C
distribute.o: distribute.C 
	$(CCC)  $(CPPFLAGS)  -c distribute.C
distribute_test: distribute.C nbody_MP.o
	$(CCC)  $(CPPFLAGS)  -o distribute_test -DTESTMAIN distribute.C  nbody_MP.o
splitsnap: splitsnap.C pgetopt.o
	$(CCC)  $(CPPFLAGS)  -o splitsnap -DTESTMAIN splitsnap.C  pgetopt.o

samplelog:  nbody
	nbody -i samplein > samplelog
samplelog_g4:  nbody_g4
	nbody_g4 -i samplein > samplelog_g4

document: .document
	ls -al .document
.document: nbody_guide.tex
	latex nbody_guide
	latex2web.csh nbody_guide $(WEBDIR) 
	touch .document
.web: export.tar.gz .document
	/bin/cp -p export.tar.gz  $(WEBDIR)
	touch .web
web: .web
	ls -al .web

